document.addEventListener('DOMContentLoaded', function () {

    // --- ELEMENTOS DEL DOM ---
    const projectGridList = document.getElementById('project-grid-list');

    // --- URLs DE LA API ---
    const PROJECTS_API_URL = 'api/projects.php';

    // --- FUNCIONES DE CARGA INICIAL ---

    async function initialLoad() {
        try {
            const projectsRes = await fetch(PROJECTS_API_URL);
            if (!projectsRes.ok) throw new Error('No se pudieron cargar los proyectos.');
            
            const projects = await projectsRes.json();
            renderProjectList(projects);

        } catch (error) {
            console.error("Error en la carga inicial:", error);
            projectGridList.innerHTML = `<div class="alert alert-danger">${error.message}</div>`;
        }
    }

    function renderProjectList(projects) {
        projectGridList.innerHTML = '';
        const eligibleProjects = projects.filter(p => p.tipo_marketing === 'Digital' || p.tipo_marketing === 'Mixto');

        if (eligibleProjects.length === 0) {
            projectGridList.innerHTML = '<p class="text-muted">No hay proyectos con marketing digital o mixto para mostrar.</p>';
            return;
        }

        eligibleProjects.forEach(project => {
            const projectItem = document.createElement('a');
            projectItem.href = `grid-detail.html?project_id=${project.id}`;
            projectItem.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-center';
            projectItem.innerHTML = `
                <div>
                    <h5 class="mb-1">${project.nombre_proyecto}</h5>
                    <small>Estado: ${project.estado}</small>
                </div>
                <i class="bi bi-arrow-right-circle-fill fs-4"></i>
            `;
            projectGridList.appendChild(projectItem);
        });
    }

    // --- CARGA INICIAL ---
    initialLoad();
});