<?php
header("Content-Type: application/json");

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    // 1. Recibir el contexto del posteo específico
    $tipo_contenido = $input['tipo_contenido'] ?? 'Flyer';
    $objetivo = $input['objetivo'] ?? 'Generar interacción.';
    $hook = $input['hook'] ?? 'Un gancho atractivo.';
    $copy = $input['copy'] ?? 'Un texto genérico.';

    $prompt_base = "Actúa como un Director Creativo experto en una agencia de publicidad. Para un posteo con el siguiente contexto:\n" .
                   "- Objetivo: $objetivo\n" .
                   "- Hook: $hook\n" .
                   "- Copy: $copy\n" .
                   "- Formato: $tipo_contenido\n\n";

    $generated_asset = "";

    // 2. Construir un prompt diferente según el tipo de contenido
    if (in_array($tipo_contenido, ['Flyer', 'Carrusel', 'Story'])) {
        $prompt = $prompt_base . "Genera un prompt detallado para un generador de imágenes (como DALL-E o Midjourney) para crear el visual principal. " .
                  "Describe la escena, estilo, colores y composición. Responde solo con el prompt.";
        
        // 3. Simulación de respuesta de IA para imágenes
        sleep(2);
        $generated_asset = "Prompt para IA de Imagen:\n\n" .
                           "Fotografía cinematográfica de alta calidad de un producto [describir producto] sobre una superficie de mármol minimalista. " .
                           "Iluminación suave y natural desde una ventana lateral. Paleta de colores cálidos y terrosos. " .
                           "En el fondo, una planta desenfocada para dar profundidad. Estilo elegante y moderno. --ar 16:9 --style raw";

    } elseif (in_array($tipo_contenido, ['Video', 'Reel'])) {
        $prompt = $prompt_base . "Genera un guion breve (3 a 5 escenas) para este video. " .
                  "Describe cada escena, la acción, el texto en pantalla y la música sugerida. Responde solo con el guion.";

        // 3. Simulación de respuesta de IA para video
        sleep(3);
        $generated_asset = "Guion para Video/Reel:\n\n" .
                           "**Escena 1:** (2s) Plano detalle rápido de un problema común del cliente. Música de intriga.\n" .
                           "**Escena 2:** (3s) Transición rápida. Mostramos nuestro producto en acción, solucionando el problema. Texto en pantalla: 'La solución que esperabas'.\n" .
                           "**Escena 3:** (2s) Plano de un cliente sonriendo, satisfecho. Música cambia a algo positivo y enérgico.\n" .
                           "**Escena 4:** (2s) Cierre con el logo de la marca y el Call to Action del copy. Música llega a su clímax.";
    }

    echo json_encode(['creative_asset' => $generated_asset]);

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>