<?php
header("Content-Type: application/json");

$upload_dir = '../uploads/';

if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file'];

    if ($file['error'] !== UPLOAD_ERR_OK) {
        http_response_code(500);
        echo json_encode(['error' => 'Error durante la subida del archivo.']);
        exit;
    }

    // Generar un nombre de archivo único para evitar sobreescrituras
    $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $unique_filename = uniqid('file_', true) . '.' . $file_extension;
    $destination = $upload_dir . $unique_filename;

    if (move_uploaded_file($file['tmp_name'], $destination)) {
        // Devolver la ruta relativa accesible desde el frontend
        echo json_encode(['filePath' => 'uploads/' . $unique_filename, 'fileName' => $file['name']]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'No se pudo mover el archivo subido.']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'No se recibió ningún archivo.']);
}
?>