<?php
header("Content-Type: application/json");

$database_path = '../config/database.json';
$uploads_dir = '../uploads/agency/';

if (!is_dir($uploads_dir)) {
    mkdir($uploads_dir, 0777, true);
}

function get_database() {
    global $database_path;
    if (!file_exists($database_path)) {
        return [];
    }
    $json_data = file_get_contents($database_path);
    return json_decode($json_data, true);
}

function save_database($data) {
    global $database_path;
    file_put_contents($database_path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $db = get_database();
    $settings = $db['settings'] ?? ['agency_data' => []];
    echo json_encode($settings);

} elseif ($method === 'POST') {
    $db = get_database();

    // Inicializa la sección de configuración si no existe
    if (!isset($db['settings'])) {
        $db['settings'] = ['agency_data' => []];
    }

    // Determinar qué formulario se está guardando
    if (isset($_POST['form_type']) && $_POST['form_type'] === 'agency_data') {
        // --- GUARDAR DATOS DE LA AGENCIA ---
        $agency_data = $_POST;
        $logo_path = $db['settings']['agency_data']['logo_url'] ?? null; // Mantener el logo anterior por si no se sube uno nuevo

        // Manejo de la subida del logo
        if (isset($_FILES['logo']) && $_FILES['logo']['error'] === UPLOAD_ERR_OK) {
            $tmp_name = $_FILES['logo']['tmp_name'];
            $file_name = 'logo_' . time() . '_' . basename($_FILES['logo']['name']);
            $destination = $uploads_dir . $file_name;

            // Eliminar el logo antiguo si existe
            if ($logo_path && file_exists('..' . $logo_path)) {
                unlink('..' . $logo_path);
            }

            if (move_uploaded_file($tmp_name, $destination)) {
                // Guardar la ruta relativa accesible desde el frontend
                $logo_path = str_replace('..', '', $destination);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'No se pudo mover el archivo subido.']);
                exit;
            }
        }

        // Construir el objeto de datos de la agencia
        $updated_agency_data = [
            'agency_name' => $agency_data['agency_name'] ?? '',
            'business_name' => $agency_data['business_name'] ?? '',
            'ruc' => $agency_data['ruc'] ?? '',
            'commercial_email' => $agency_data['commercial_email'] ?? '',
            'commercial_phone' => $agency_data['commercial_phone'] ?? '',
            'finance_email' => $agency_data['finance_email'] ?? '',
            'finance_phone' => $agency_data['finance_phone'] ?? '',
            'website' => $agency_data['website'] ?? '',
            'legal_rep' => $agency_data['legal_rep'] ?? '',
            'address' => $agency_data['address'] ?? '',
            'city' => $agency_data['city'] ?? '',
            'country' => $agency_data['country'] ?? '',
            'logo_url' => $logo_path
        ];

        // Actualizar la base de datos
        $db['settings']['agency_data'] = $updated_agency_data;

    } elseif (isset($_POST['form_type']) && $_POST['form_type'] === 'system_settings') {
        // --- GUARDAR AJUSTES DEL SISTEMA ---
        $system_data = $_POST;
        $updated_system_settings = [
            'thousands_separator' => $system_data['thousands_separator'] ?? '.',
            'decimal_separator' => $system_data['decimal_separator'] ?? ',',
            'decimal_places' => isset($system_data['decimal_places']) ? (int)$system_data['decimal_places'] : 0,
            'percentage_decimals' => isset($system_data['percentage_decimals']) ? (int)$system_data['percentage_decimals'] : 1,
            'currency_code' => $system_data['currency_code'] ?? 'PYG',
            'currency_symbol' => $system_data['currency_symbol'] ?? 'Gs.',
        ];

        // Actualizar la base de datos
        $db['settings']['system_settings'] = $updated_system_settings;

    } elseif (isset($_POST['form_type']) && $_POST['form_type'] === 'ai_settings') {
        // --- GUARDAR AJUSTES DE IA ---
        $ai_data = $_POST;
        // Asegurarse de que el nodo 'ai_settings' exista antes de intentar acceder a él.
        $current_ai_settings = $db['settings']['ai_settings'] ?? [];

        // Si se envía una nueva clave, se usa. Si no, se mantiene la que ya estaba guardada.
        // Esto evita que se borre la clave si el usuario no la introduce de nuevo.
        $new_api_key = $ai_data['api_key'] ?? null;
        $api_key_to_save = !empty($new_api_key) ? $new_api_key : ($current_ai_settings['api_key'] ?? '');

        $updated_ai_settings = [
            'ai_provider' => $ai_data['ai_provider'] ?? 'gemini',
            'ai_model' => $ai_data['ai_model'] ?? '',
            'api_key' => $api_key_to_save,
        ];
        $db['settings']['ai_settings'] = array_merge($current_ai_settings, $updated_ai_settings);

    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Tipo de formulario no reconocido.']);
        exit;
    }

    save_database($db);

    http_response_code(200);
    echo json_encode([
        'message' => 'Configuración guardada con éxito.',
        'data' => $db['settings']
    ]);

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>