<?php
header("Content-Type: application/json");

$database_path = '../config/database.json';

function get_database() {
    global $database_path;
    if (!file_exists($database_path)) {
        return [];
    }
    $json_data = file_get_contents($database_path);
    return json_decode($json_data, true);
}

function save_database($data) {
    global $database_path;
    file_put_contents($database_path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if ($method === 'GET') {
    $db = get_database();
    $invoices = $db['invoices'] ?? [];

    if ($id !== null) {
        $invoice = array_values(array_filter($invoices, function($inv) use ($id) {
            return $inv['id'] === $id;
        }));
        if (count($invoice) > 0) {
            echo json_encode($invoice[0]);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Factura no encontrada']);
        }
    } else {
        // Poblar con nombre de cliente
        $clients = array_column($db['clients'] ?? [], 'nombre_empresa', 'id');
        foreach ($invoices as &$invoice) {
            $invoice['client_name'] = $clients[$invoice['client_id']] ?? 'N/A';
        }
        echo json_encode($invoices);
    }
} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();

    if (!isset($db['invoices'])) {
        $db['invoices'] = [];
    }

    $new_id = empty($db['invoices']) ? 1 : max(array_column($db['invoices'], 'id')) + 1;
    
    $new_invoice = $input;
    $new_invoice['id'] = $new_id;

    $db['invoices'][] = $new_invoice;
    save_database($db);

    http_response_code(201);
    echo json_encode($new_invoice);

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();
    
    $found = false;
    foreach ($db['invoices'] as $key => $invoice) {
        if ($invoice['id'] === $id) {
            $db['invoices'][$key] = array_merge($invoice, $input);
            $db['invoices'][$key]['id'] = $id; // Asegurar que el ID no cambie
            $updated_invoice = $db['invoices'][$key];
            $found = true;
            break;
        }
    }

    if ($found) {
        save_database($db);
        echo json_encode($updated_invoice);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Factura no encontrada para actualizar']);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    $db = get_database();
    
    $original_count = count($db['invoices'] ?? []);
    $db['invoices'] = array_values(array_filter($db['invoices'] ?? [], function($inv) use ($id) {
        return $inv['id'] !== $id;
    }));
    
    if (count($db['invoices']) < $original_count) {
        save_database($db);
        http_response_code(204);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Factura no encontrada']);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>