<?php
header("Content-Type: application/json");

// Simulación de un endpoint que llama a una IA para generar una grilla de contenidos

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    // 1. Recibir el contexto del frontend
    $estrategico = $input['estrategico'] ?? 'Definir objetivos generales.';
    $tactico = $input['tactico'] ?? 'Crear campañas específicas.';
    $operativo = $input['operativo'] ?? 'Realizar publicaciones diarias.';

    // 2. Construir el prompt para la IA
    $prompt = "Actúa como un experto Community Manager. Basado en la siguiente estrategia de marketing:\n" .
              "- Estratégico: $estrategico\n" .
              "- Táctico: $tactico\n" .
              "- Operativo: $operativo\n" .
              "Genera una lista de 3 a 5 ideas de posteos para redes sociales para los próximos 10 días. " .
              "Responde únicamente con un array JSON de objetos. Cada objeto debe tener las siguientes claves: " .
              "'fecha_posteo' (formato YYYY-MM-DD), 'hora_posteo' (formato HH:MM), 'tipo_contenido' (ej: 'Carrusel', 'Video', 'Flyer'), " .
              "'redes' (un array, ej: ['Instagram', 'Facebook']), 'objetivo', 'hook', 'copy', 'hashtags', 'cta', 'publico_objetivo' y 'resultado_esperado'.";

    // 3. (HIPOTÉTICO) Aquí se haría la llamada a la API de la IA.
    // 4. Como simulación, devolvemos una respuesta de ejemplo.
    sleep(2); // Simular el tiempo de respuesta de la IA

    $response_data = [
        [
            "fecha_posteo" => date('Y-m-d', strtotime('+2 days')), "hora_posteo" => "19:00", "tipo_contenido" => "Carrusel Educativo", "redes" => ["Instagram", "Facebook"],
            "objetivo" => "Educar sobre el problema que resolvemos", "hook" => "¿Sabías que el 70% de las empresas luchan con esto?", "copy" => "Desliza para descubrir 3 errores comunes en [tema] y cómo puedes superarlos fácilmente. ➡️",
            "hashtags" => "#TipsDeNegocio #Crecimiento #MarketingDigital", "cta" => "Guarda este post para más tarde.", "publico_objetivo" => "Emprendedores y dueños de PYMES", "resultado_esperado" => "100 guardados, 20 comentarios"
        ],
        [
            "fecha_posteo" => date('Y-m-d', strtotime('+5 days')), "hora_posteo" => "20:30", "tipo_contenido" => "Video Testimonial", "redes" => ["Instagram", "LinkedIn"],
            "objetivo" => "Generar confianza y prueba social", "hook" => "Así es como [Cliente] transformó su negocio.", "copy" => "¡Nuestro cliente [NombreCliente] logró [resultado] en solo 2 semanas! 🚀 Escucha su historia y cómo lo hicimos posible. ¿Quieres ser el próximo?",
            "hashtags" => "#CasoDeExito #ResultadosReales #Testimonio", "cta" => "¡Comenta 'QUIERO' y te contactamos por DM!", "publico_objetivo" => "Gerentes de Marketing", "resultado_esperado" => "50 comentarios, 10 leads"
        ],
    ];

    echo json_encode($response_data);

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>