document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('editorial-calendar');
    const GRID_POSTS_API_URL = 'api/grid_posts.php';

    async function initialLoad() {
        try {
            const gridPostsRes = await fetch(GRID_POSTS_API_URL);
            if (!gridPostsRes.ok) throw new Error('No se pudieron cargar los posteos de la grilla.');
            
            const gridPosts = await gridPostsRes.json();
            renderCalendar(gridPosts);

        } catch (error) {
            console.error("Error en la carga de la agenda editorial:", error);
            calendarEl.innerHTML = `<div class="alert alert-danger">Error al cargar el calendario: ${error.message}</div>`;
        }
    }

    function renderCalendar(gridPosts) {
        const postEvents = gridPosts.filter(post => post.fecha_posteo).map(post => ({
            title: `Posteo: ${post.tipo_contenido}`,
            start: `${post.fecha_posteo}T${post.hora_posteo || '12:00:00'}`,
            allDay: false,
            url: `grid-editor.html?grid_id=${post.grid_id}`,
            backgroundColor: '#fd7e14', // Naranja
            borderColor: '#fd7e14',
            extendedProps: {
                copy: post.copy
            }
        }));

        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'es',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,listWeek'
            },
            events: postEvents,
            eventTimeFormat: {
                hour: 'numeric',
                minute: '2-digit',
                meridiem: false
            }
        });
        calendar.render();
    }

    initialLoad();
});