<?php
header('Content-Type: application/json');

function send_response($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data);
    exit;
}

$messages_file = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/data/messages.json';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_response(['success' => false, 'message' => 'Método no permitido.'], 405);
}

$data = json_decode(file_get_contents('php://input'), true);
$message_id = $data['id'] ?? null;

if (empty($message_id)) {
    send_response(['success' => false, 'message' => 'No se proporcionó el ID del mensaje.'], 400);
}

if (!file_exists($messages_file)) {
    send_response(['success' => true, 'message' => 'El archivo de mensajes no existe, no hay nada que marcar.']);
}

$messages = json_decode(file_get_contents($messages_file), true);
$message_found = false;

foreach ($messages as $key => &$message) { // Usar referencia (&) para modificar el array
    if ($message['id'] === $message_id) {
        $message['read'] = true;
        $message_found = true;
        break;
    }
}

if ($message_found) {
    file_put_contents($messages_file, json_encode($messages, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// Devolver éxito incluso si el mensaje ya estaba leído o no se encontró, para no mostrar un error al usuario.
send_response(['success' => true]);