<?php
session_start();

function redirect_with_error() {
    header('Location: ../login.html?error=1');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect_with_error();
}

$username_input = $_POST['username'] ?? '';
$password_input = $_POST['password'] ?? '';

if (empty($username_input) || empty($password_input)) {
    redirect_with_error();
}

$users_file = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/data/users.json';
if (!file_exists($users_file)) {
    redirect_with_error();
}

$users = json_decode(file_get_contents($users_file), true);

foreach ($users as $user) {
    if (strtolower($user['username']) === strtolower($username_input)) {
        if (password_verify($password_input, $user['password'])) {
            // Autenticación exitosa
            $_SESSION['user_logged_in'] = true;
            $_SESSION['user_name'] = $user['full_name'];
            header('Location: ../copesa-admin.php');
            exit;
        }
    }
}

// Si el bucle termina, el usuario o la contraseña son incorrectos
redirect_with_error();