<?php
header('Content-Type: application/json');

// Función para enviar una respuesta de error
function send_error($message) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $message]);
    exit;
}

// Solo permitir solicitudes POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_error('Método no permitido.');
}

// Leer los datos JSON enviados
$data = json_decode(file_get_contents('php://input'), true);
$message_id = $data['id'] ?? null;

if (empty($message_id)) {
    send_error('No se proporcionó el ID del mensaje.');
}

// Ruta al archivo de mensajes
$json_file = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/data/messages.json';

if (!file_exists($json_file) || !is_writable($json_file)) {
    send_error('El archivo de mensajes no existe o no se puede escribir en él.');
}

// Leer los mensajes, encontrar y eliminar el correcto
$messages = json_decode(file_get_contents($json_file), true);

// Filtrar el array, manteniendo todos los mensajes excepto el que coincide con el ID
$updated_messages = array_filter($messages, function($msg) use ($message_id) {
    return $msg['id'] !== $message_id;
});

// Re-indexar el array para evitar que se convierta en un objeto si las claves no son secuenciales
$updated_messages = array_values($updated_messages);

// Guardar el array actualizado
if (file_put_contents($json_file, json_encode($updated_messages, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) !== false) {
    echo json_encode(['success' => true, 'message' => 'Mensaje eliminado con éxito.']);
} else {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error al guardar los cambios en el archivo de mensajes.']);
}