<?php
header('Content-Type: application/json');

$projects_file = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/data/projects.json';
$upload_dir = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/uploads/projects/';

function send_response($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data);
    exit;
}

function get_projects($file) {
    if (!file_exists($file)) return [];
    return json_decode(file_get_contents($file), true) ?: [];
}

function save_projects($file, $projects) {
    return file_put_contents($file, json_encode($projects, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    send_response(get_projects($projects_file));
}

if ($method === 'POST') {
    // Asegurarse de que el directorio de subida exista
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    $action = $_POST['action'] ?? 'create';

    if ($action === 'create') {
        $title = trim($_POST['project_title'] ?? '');
        $subtitle = trim($_POST['project_subtitle'] ?? '');
        $category = trim($_POST['project_category'] ?? '');
        $description = trim($_POST['project_description'] ?? '');

        if (empty($title) || empty($category) || empty($_FILES['project_images'])) {
            send_response(['success' => false, 'message' => 'Título, categoría y al menos una imagen son obligatorios.'], 400);
        }

        $image_paths = [];
        $total_files = count($_FILES['project_images']['name']);

        for ($i = 0; $i < $total_files; $i++) {
            if ($_FILES['project_images']['error'][$i] === UPLOAD_ERR_OK) {
                $tmp_name = $_FILES['project_images']['tmp_name'][$i];
                $original_name = $_FILES['project_images']['name'][$i];
                $file_extension = pathinfo($original_name, PATHINFO_EXTENSION);
                $new_filename = uniqid('proj_') . '.' . $file_extension;
                $destination = $upload_dir . $new_filename;

                if (move_uploaded_file($tmp_name, $destination)) {
                    // Guardar la ruta relativa al servidor
                    $image_paths[] = '/webcopesa/uploads/projects/' . $new_filename;
                }
            }
        }

        if (empty($image_paths)) {
            send_response(['success' => false, 'message' => 'Error al subir las imágenes.'], 500);
        }

        $new_project = [
            'id' => uniqid('proj_'),
            'title' => htmlspecialchars($title),
            'subtitle' => htmlspecialchars($subtitle),
            'category' => htmlspecialchars($category),
            'description' => htmlspecialchars($description),
            'images' => $image_paths,
            'main_image' => $image_paths[0] // La primera imagen será la principal/portada
        ];

        $projects = get_projects($projects_file);
        array_unshift($projects, $new_project); // Añadir al principio

        if (save_projects($projects_file, $projects)) {
            send_response(['success' => true, 'message' => 'Proyecto creado con éxito.']);
        } else {
            send_response(['success' => false, 'message' => 'Error al guardar el proyecto.'], 500);
        }
    }

    if ($action === 'edit') {
        $id = $_POST['id'] ?? null;
        if (empty($id)) {
            send_response(['success' => false, 'message' => 'No se proporcionó el ID del proyecto.'], 400);
        }

        $projects = get_projects($projects_file);
        $project_found = false;

        foreach ($projects as $key => &$project) {
            if ($project['id'] === $id) {
                $project['title'] = htmlspecialchars(trim($_POST['project_title'] ?? $project['title']));
                $project['subtitle'] = htmlspecialchars(trim($_POST['project_subtitle'] ?? $project['subtitle']));
                $project['category'] = htmlspecialchars(trim($_POST['project_category'] ?? $project['category']));
                $project['description'] = htmlspecialchars(trim($_POST['project_description'] ?? $project['description']));

                // --- Lógica de Gestión de Imágenes ---
                $kept_images = $_POST['kept_images'] ?? [];
                $current_images = $project['images'];

                // 1. Eliminar imágenes que el usuario desmarcó
                foreach ($current_images as $current_image) {
                    if (!in_array($current_image, $kept_images)) {
                        $full_path = $_SERVER['DOCUMENT_ROOT'] . $current_image;
                        if (file_exists($full_path)) {
                            unlink($full_path);
                        }
                    }
                }

                // 2. Subir y añadir nuevas imágenes
                $new_image_paths = [];
                if (!empty($_FILES['project_images']['name'][0])) {
                    $total_files = count($_FILES['project_images']['name']);
                    for ($i = 0; $i < $total_files; $i++) {
                        if ($_FILES['project_images']['error'][$i] === UPLOAD_ERR_OK) {
                            $tmp_name = $_FILES['project_images']['tmp_name'][$i];
                            $new_filename = uniqid('proj_') . '.' . pathinfo($_FILES['project_images']['name'][$i], PATHINFO_EXTENSION);
                            if (move_uploaded_file($tmp_name, $upload_dir . $new_filename)) {
                                $new_image_paths[] = '/webcopesa/uploads/projects/' . $new_filename;
                            }
                        }
                    }
                }
                
                // 3. Combinar imágenes mantenidas y nuevas
                $project['images'] = array_merge($kept_images, $new_image_paths);
                $project['main_image'] = $project['images'][0] ?? ''; // La primera imagen es la principal

                $project_found = true;
                break;
            }
        }

        if (!$project_found) {
            send_response(['success' => false, 'message' => 'Proyecto no encontrado.'], 404);
        }

        if (save_projects($projects_file, $projects)) {
            send_response(['success' => true, 'message' => 'Proyecto actualizado con éxito.']);
        } else {
            send_response(['success' => false, 'message' => 'Error al actualizar el proyecto.'], 500);
        }
    }

    if ($action === 'delete') {
        $id = $_POST['id'] ?? null;
        $projects = get_projects($projects_file);
        $project_to_delete = null;
        
        $updated_projects = array_filter($projects, function($p) use ($id, &$project_to_delete) {
            if ($p['id'] === $id) {
                $project_to_delete = $p;
                return false; // Eliminar de la lista
            }
            return true;
        });

        if ($project_to_delete) {
            // Eliminar las imágenes del servidor
            foreach ($project_to_delete['images'] as $image_path) {
                $full_path = $_SERVER['DOCUMENT_ROOT'] . $image_path;
                if (file_exists($full_path)) {
                    unlink($full_path);
                }
            }
        }

        save_projects($projects_file, array_values($updated_projects));
        send_response(['success' => true, 'message' => 'Proyecto eliminado con éxito.']);
    }
}

send_response(['success' => false, 'message' => 'Acción no válida.'], 400);
?>