<?php
header('Content-Type: application/json');

$config_file = $_SERVER['DOCUMENT_ROOT'] . '/webcopesa/data/config.json';

function send_error($message, $code = 400) {
    http_response_code($code);
    echo json_encode(['success' => false, 'message' => $message]);
    exit;
}

// Asegurarse de que el archivo de configuración exista y se pueda escribir en él.
if (!file_exists($config_file) || !is_writable($config_file)) {
    send_error('El archivo de configuración no existe o no tiene permisos de escritura.', 500);
}

// Manejar la solicitud
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Devolver la configuración actual
    $config = file_get_contents($config_file);
    echo $config;
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Actualizar la configuración
    $data = json_decode(file_get_contents('php://input'), true);

    // Leer la configuración actual
    $current_config = json_decode(file_get_contents($config_file), true);

    // Actualizar solo las claves proporcionadas
    $current_config['recaptcha_site_key'] = $data['recaptcha_site_key'] ?? $current_config['recaptcha_site_key'];
    // La clave secreta solo se actualiza si se envía una nueva, no se expone en el GET
    if (isset($data['recaptcha_secret_key'])) {
        $current_config['recaptcha_secret_key'] = $data['recaptcha_secret_key'];
    }
    $current_config['ga_measurement_id'] = $data['ga_measurement_id'] ?? $current_config['ga_measurement_id'];

    // Guardar la nueva configuración
    if (file_put_contents($config_file, json_encode($current_config, JSON_PRETTY_PRINT))) {
        echo json_encode(['success' => true, 'message' => 'Configuración guardada con éxito.']);
    } else {
        send_error('No se pudo guardar la configuración.', 500);
    }
    exit;
}

send_error('Método no permitido.');