<?php
session_start(); // Ensure session is started
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Trabajos Realizados - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4">Reporte de Trabajos Realizados</h2>
        <div id="report-container">
            <!-- El reporte de trabajos realizados se cargará aquí -->
            <p class="text-muted">Cargando reporte de trabajos...</p>
        </div>

        <h3 class="mt-5 mb-3">Reporte de Carga de Trabajo por Usuario</h3>
        <div id="workload-report-table-container" class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Usuario</th>
                        <th>Tareas Asignadas</th>
                        <th>Tareas Completadas</th>
                        <th>Tareas Pendientes</th>
                        <th>Horas Registradas</th>
                    </tr>
                </thead>
                <tbody id="workloadReportBody">
                    <!-- Los datos de carga de trabajo se cargarán aquí -->
                    <tr><td colspan="5" class="text-center text-muted">Cargando reporte de carga de trabajo...</td></tr>
                </tbody>
            </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
    <script src="js/work_logs_report.js"></script>
    <input type="hidden" id="userEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">
    <?php include 'chat_widget.php'; ?>
</body>
</html>