<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tareas - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/frappe-gantt@0.6.1/dist/frappe-gantt.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body, html {
            height: 100%;
            margin: 0;
            overflow: hidden;
        }
        .main-container {
            display: flex;
            flex-direction: column;
            height: 100vh;
        }
        .split-container {
            display: flex;
            flex-grow: 1;
            overflow: hidden;
            padding: 1rem;
            gap: 1rem;
        }
        #split-left, #split-right {
            overflow: auto;
            height: 100%;
        }
        .gutter {
            background-color: #eee;
            background-repeat: no-repeat;
            background-position: 50%;
        }
        .gutter.gutter-horizontal {
            background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAAIklEQVQoU2M4c+bM/5+BgYGBgYGBgYGBgYGBgYGBgYGRgQEAJbYF/sO3bXoAAAAASUVORK5CYII=');
            cursor: col-resize;
        }
        #split-left {
            display: flex;
            flex-direction: column;
        }
        .task-list-scroll-container {
            flex-grow: 1;
            overflow-y: auto;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <?php include 'menu.php'; ?>

        <div class="split-container">
            <div id="split-left">
                <h3>Listado de Tareas</h3>
                <hr>
                <div class="task-list-scroll-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>Tarea</th>
                                    <th>Proyecto</th>
                                    <th>Inicio</th>
                                    <th>Fin</th>
                                    <th>Progreso</th>
                                    <th>Responsable</th>
                                    <th>Acciones</th>
                                </tr>
                                <tr id="task-filter-row">
                                    <th><input type="text" class="form-control form-control-sm task-filter" id="filterTaskName" placeholder="Filtrar Tarea"></th>
                                    <th><input type="text" class="form-control form-control-sm task-filter" id="filterTaskProject" placeholder="Filtrar Proyecto"></th>
                                    <th><input type="date" class="form-control form-control-sm task-filter" id="filterTaskStart"></th>
                                    <th><input type="date" class="form-control form-control-sm task-filter" id="filterTaskEnd"></th>
                                    <th><input type="text" class="form-control form-control-sm task-filter" id="filterTaskProgress" placeholder=">, <, =..."></th>
                                    <th><input type="text" class="form-control form-control-sm task-filter" id="filterTaskResponsibleText" placeholder="Filtrar Responsable"></th>
                                    <th><button type="button" class="btn btn-sm btn-secondary" id="clearFilters">Limpiar</button></th>
                                </tr>
                            </thead>
                            <tbody id="taskListBody">
                                <!-- Las tareas se cargarán aquí -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div id="split-right">
                <div class="d-flex justify-content-between align-items-center">
                    <h2 class="mb-0" id="gantt-title">Diagrama de Gantt</h2>
                    <?php if ($_SESSION['user_role'] === 'admin' || $_SESSION['user_role'] === 'project_manager'): ?>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#taskModal">Añadir Tarea</button>
                    <?php endif; ?>
                </div>
                <hr>
                <div id="project-details" class="row mt-2 mb-3"></div>
                <div class="gantt-container-wrapper">
                    <svg id="gantt"></svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para Añadir/Editar Tarea -->
    <div class="modal fade" id="taskModal" tabindex="-1" aria-labelledby="taskModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="taskModalLabel">Añadir Tarea</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="taskForm">
                        <input type="hidden" id="taskId">
                        <ul class="nav nav-tabs" id="taskTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="task-details-tab" data-bs-toggle="tab" data-bs-target="#task-details" type="button" role="tab" aria-controls="task-details" aria-selected="true">Detalles de la Tarea</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="work-logs-tab" data-bs-toggle="tab" data-bs-target="#work-logs" type="button" role="tab" aria-controls="work-logs" aria-selected="false">Trabajos Realizados</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="comments-tab" data-bs-toggle="tab" data-bs-target="#comments" type="button" role="tab" aria-controls="comments" aria-selected="false">Comentarios</button>
                            </li>
                        </ul>
                        <div class="tab-content" id="taskTabContent">
                            <div class="tab-pane fade show active" id="task-details" role="tabpanel" aria-labelledby="task-details-tab">
                                <div class="mb-3 mt-3">
                                    <label for="taskProject" class="form-label">Proyecto</label>
                                    <select class="form-select" id="taskProject" required>
                                        <!-- Opciones de proyecto se cargarán aquí -->
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="taskParent" class="form-label">Tarea Padre (Opcional)</label>
                                    <select class="form-select" id="taskParent">
                                        <!-- Opciones de tareas padre se cargarán aquí -->
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="taskName" class="form-label">Nombre de la Tarea</label>
                                    <input type="text" class="form-control" id="taskName" required>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="taskStart" class="form-label">Fecha de Inicio</label>
                                        <input type="date" class="form-control" id="taskStart" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="taskEnd" class="form-label">Fecha de Fin</label>
                                        <input type="date" class="form-control" id="taskEnd" required>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="taskProgress" class="form-label">Progreso (%)</label>
                                    <input type="number" class="form-control" id="taskProgress" min="0" max="100" value="0">
                                </div>
                                <div class="mb-3">
                                    <label for="taskResponsible" class="form-label">Responsable</label>
                                    <select class="form-select" id="taskResponsible">
                                        <!-- Opciones de usuario se cargarán aquí -->
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="taskDependencies" class="form-label">Dependencias (IDs separados por coma)</label>
                                    <input type="text" class="form-control" id="taskDependencies">
                                </div>
                            </div>
                            <div class="tab-pane fade" id="work-logs" role="tabpanel" aria-labelledby="work-logs-tab">
                                <div class="mt-3">
                                    <h5>Registrar Nuevo Trabajo</h5>
                                    <div class="row g-2">
                                        <div class="col-md-4">
                                            <label for="workLogType" class="form-label visually-hidden">Tipo de Trabajo</label>
                                            <select class="form-select form-select-sm" id="workLogType">
                                                <option value="">Tipo de Trabajo</option>
                                                <option value="Gabinete">Gabinete</option>
                                                <option value="Campo">Campo</option>
                                                <option value="Reunion">Reunión</option>
                                                <option value="Llamada">Llamada</option>
                                                <option value="Visita">Visita</option>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="workLogDate" class="form-label visually-hidden">Fecha</label>
                                            <input type="date" class="form-control form-control-sm" id="workLogDate">
                                        </div>
                                        <div class="col-md-2">
                                            <label for="workLogStartTime" class="form-label visually-hidden">Hora Inicio</label>
                                            <input type="time" class="form-control form-control-sm" id="workLogStartTime">
                                        </div>
                                        <div class="col-md-2">
                                            <label for="workLogEndTime" class="form-label visually-hidden">Hora Fin</label>
                                            <input type="time" class="form-control form-control-sm" id="workLogEndTime">
                                        </div>
                                        <div class="col-12">
                                            <label for="workLogDescription" class="form-label visually-hidden">Descripción</label>
                                            <textarea class="form-control form-control-sm" id="workLogDescription" rows="3" placeholder="¿Qué se hizo?"></textarea>
                                        </div>
                                        <div class="col-12">
                                            <label for="workLogLink" class="form-label visually-hidden">Link a Archivos</label>
                                            <input type="url" class="form-control form-control-sm" id="workLogLink" placeholder="Enlace a archivos (opcional)">
                                        </div>
                                        <div class="col-12 text-end">
                                            <button type="button" class="btn btn-sm btn-success" id="addWorkLogBtn">Agregar Trabajo</button>
                                        </div>
                                    </div>
                                    <hr>
                                    <h5>Historial de Trabajos</h5>
                                    <div id="workLogsList" class="list-group">
                                        <!-- Work logs will be loaded here -->
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="comments" role="tabpanel" aria-labelledby="comments-tab">
                                <div class="mt-3">
                                    <h5>Comentarios</h5>
                                    <div id="commentsList" class="list-group mb-3" style="max-height: 300px; overflow-y: auto;">
                                        <!-- Comments will be loaded here -->
                                    </div>
                                    <div class="mb-3">
                                        <label for="newCommentText" class="form-label">Añadir un comentario:</label>
                                        <div class="position-relative">
                                            <textarea class="form-control" id="newCommentText" rows="3" autocomplete="off"></textarea>
                                            <div id="mention-suggestions" class="dropdown-menu" style="width: 100%;"></div>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label for="commentAttachment" class="form-label">Adjuntar archivo (opcional):</label>
                                        <input class="form-control form-control-sm" type="file" id="commentAttachment">
                                    </div>
                                    <button type="button" class="btn btn-sm btn-success" id="addCommentBtn">Enviar Comentario</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnDeleteTask" class="btn btn-danger me-auto" style="display: none;">Eliminar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="taskForm">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/frappe-gantt@0.6.1/dist/frappe-gantt.min.js"></script>
    <script src="https://unpkg.com/split.js/dist/split.min.js"></script>
    <script src="js/tareas.js"></script>
    <input type="hidden" id="userEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">

    <script>
        // Only initialize Split.js on larger screens
        if (window.innerWidth > 768) {
            Split(['#split-left', '#split-right'], {
                sizes: [50, 50],
                minSize: 300,
                gutterSize: 10,
                cursor: 'col-resize'
            });
        }
    </script>
</body>
</html>