<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}

$project_id = $_GET['project_id'] ?? null;
if (!$project_id) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Finanzas del Proyecto - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4">Finanzas del Proyecto: <span id="projectName"></span></h2>
        <input type="hidden" id="projectId" value="<?php echo htmlspecialchars($project_id); ?>">

        <div class="row mb-4">
            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Presupuesto</h5>
                        <p class="card-text display-4" id="financial-budget">$0.00</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Costo Total</h5>
                        <p class="card-text display-4" id="financial-total-cost">$0.00</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Balance</h5>
                        <p class="card-text display-4" id="financial-balance">$0.00</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Detalle de Costos</h5>
            </div>
            <div class="card-body">
                <p><strong>Costo por Horas de Trabajo:</strong> <span id="cost-work-logs">$0.00</span></p>
                <p><strong>Gastos Adicionales:</strong> <span id="cost-expenses">$0.00</span></p>
            </div>
        </div>

        <div class="card shadow-sm mb-4">
            <div class="card-header bg-light text-dark">
                <h5 class="mb-0">Gestión de Gastos</h5>
            </div>
            <div class="card-body">
                <form id="expenseForm" class="mb-4">
                    <input type="hidden" id="expenseId">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="expenseDescription" class="form-label">Descripción</label>
                            <input type="text" class="form-control" id="expenseDescription" required>
                        </div>
                        <div class="col-md-3">
                            <label for="expenseAmount" class="form-label">Monto</label>
                            <input type="number" class="form-control" id="expenseAmount" min="0" step="0.01" required>
                        </div>
                        <div class="col-md-3">
                            <label for="expenseDate" class="form-label">Fecha</label>
                            <input type="date" class="form-control" id="expenseDate" required>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">Guardar Gasto</button>
                        </div>
                    </div>
                </form>

                <h4>Listado de Gastos</h4>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>Descripción</th>
                                <th>Monto</th>
                                <th>Fecha</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="expensesTableBody">
                            <!-- Expenses will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/project_financials.js"></script>
    <input type="hidden" id="userEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">
</body>
</html>