<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Perfil - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h2 class="mb-0">Mi Perfil</h2>
                    </div>
                    <div class="card-body">
                        <div id="profile-message" class="alert" style="display:none;"></div>
                        <form id="profileForm">
                            <div class="text-center mb-4">
                                <img id="profileImagePreview" src="https://media.istockphoto.com/id/1332100919/es/vector/icono-de-hombre-icono-negro-s%C3%ADmbolo-de-persona.jpg?s=612x612&w=0&k=20&c=zf8iV9whu1NbDpw0H9A043wWjqyhPFP5m6CuesrBVFk=" alt="Foto de perfil" class="rounded-circle" width="150" height="150" style="object-fit: cover;">
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nombreCompleto" class="form-label">Nombre Completo</label>
                                    <input type="text" class="form-control" id="nombreCompleto" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Correo Electrónico</label>
                                    <input type="email" class="form-control" id="email" readonly>
                                    <small class="form-text text-muted">El correo electrónico no se puede cambiar.</small>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="direccion" class="form-label">Dirección</label>
                                <input type="text" class="form-control" id="direccion">
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="telefono" class="form-label">Número de Teléfono</label>
                                    <input type="tel" class="form-control" id="telefono">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="fechaNacimiento" class="form-label">Fecha de Nacimiento</label>
                                    <input type="date" class="form-control" id="fechaNacimiento">
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="foto" class="form-label">URL de la Fotografía</label>
                                <input type="url" class="form-control" id="foto" placeholder="https://example.com/imagen.jpg">
                            </div>
                            <hr>
                            <h5>Preferencias</h5>
                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" role="switch" id="emailNotifications">
                                <label class="form-check-label" for="emailNotifications">Recibir recordatorios de tareas por correo</label>
                            </div>
                            <div class="d-flex justify-content-between">
                                <a href="change_password.php" class="btn btn-secondary">Cambiar Contraseña</a>
                                <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/notifications.js"></script>
    <script src="js/my_profile.js"></script>
    <!-- Hidden input to pass session email to JS -->
    <input type="hidden" id="currentUserEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">
</body>
</html>