<?php
$current_page = basename($_SERVER['PHP_SELF']);
$user_role = $_SESSION['user_role'] ?? 'guest';
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand" href="index.php">Dunamis Proyectos</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <button class="btn-close d-lg-none" id="close-menu" type="button" aria-label="Close"></button>
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'home.php') ? 'active' : ''; ?>" href="home.php">Inicio</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'index.php') ? 'active' : ''; ?>" href="index.php">Proyectos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'tareas.php') ? 'active' : ''; ?>" href="tareas.php">Tareas</a>
                </li>
                <?php if ($user_role === 'admin'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'usuarios.php') ? 'active' : ''; ?>" href="usuarios.php">Usuarios</a>
                    </li>
                <?php endif; ?>
                <?php if ($user_role === 'admin' || $user_role === 'project_manager'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'clientes.php') ? 'active' : ''; ?>" href="clientes.php">Clientes</a>
                    </li>
                <?php endif; ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'chat.php') ? 'active' : ''; ?>" href="chat.php">Chat</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'work_logs_report.php') ? 'active' : ''; ?>" href="work_logs_report.php">Reporte de Trabajos</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'my_profile.php') ? 'active' : ''; ?>" href="my_profile.php">Mi Perfil</a>
                </li>
            </ul>
            <div class="d-flex align-items-center">
                <ul class="navbar-nav me-3">
                    <li class="nav-item dropdown">
                        <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="notificationDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                            Notificacion <span class="badge bg-danger ms-1" id="notification-badge" style="display: none;"></span>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notificationDropdown" id="notification-list" style="width: 300px;">
                            <li><a class="dropdown-item text-center text-muted" href="#">Cargando...</a></li>
                        </ul>
                    </li>
                </ul>
                <span class="navbar-text me-3">
                    Bienvenido, <?php echo htmlspecialchars($_SESSION['user_name']); ?>
                </span>
                <a href="change_password.php" class="btn btn-outline-light btn-sm me-2">Cambiar Contraseña</a>
                <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </div>
</nav>
<div style="padding-top: 56px;"></div>
<?php
if ($current_page !== 'chat.php') {
    include 'chat_widget.php';
}
?>
<script src="js/menu.js"></script>
