$(document).ready(function() {
    const reportContainer = $('#report-container');
    const projectsApiUrl = 'api/projects.php';
    const reportsApiUrl = 'api/reports.php'; // New API URL
    const workloadReportBody = $('#workloadReportBody'); // New table body

    function fetchAndRenderReport() {
        reportContainer.html('<p class="text-muted">Cargando reporte...</p>');

        $.ajax({
            url: projectsApiUrl,
            method: 'GET',
            success: function(projects) {
                reportContainer.empty();
                if (projects.length === 0) {
                    reportContainer.append('<div class="alert alert-info">No hay proyectos para mostrar en el reporte.</div>');
                    return;
                }

                projects.forEach(project => {
                    let projectHtml = `
                        <div class="card mb-4 shadow-sm" id="project-${project.id}">
                            <div class="card-header bg-light text-dark d-flex justify-content-between align-items-center">
                                <h4 class="mb-0">${project.nombre} <small class="text-muted">(ID: ${project.id})</small></h4>
                                <div>
                                    <button class="btn btn-sm btn-light download-pdf-btn me-2" data-project-id="${project.id}">
                                        Descargar PDF
                                    </button>
                                    <button class="btn btn-sm btn-link text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#projectBody-${project.id}" aria-expanded="false" aria-controls="projectBody-${project.id}">
                                        <i class="bi bi-chevron-down"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="collapse" id="projectBody-${project.id}">
                                <div class="card-body">
                                <p><strong>Cliente:</strong> ${project.client_name || 'N/A'}</p>
                                <p><strong>Gerente de Proyecto:</strong> ${project.gerente_proyecto || 'N/A'}</p>
                                <p><strong>Sponsor:</strong> ${project.sponsor_proyecto || 'N/A'}</p>
                                <hr>
                                <h5>Resumen Financiero:</h5>
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <div class="card text-center bg-light">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-0">Presupuesto</h6>
                                                <p class="card-text mb-0">${(project.financials.budget || 0).toFixed(2)}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card text-center bg-light">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-0">Costo Horas Hombre</h6>
                                                <p class="card-text mb-0">${(project.financials.total_work_log_cost || 0).toFixed(2)}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card text-center bg-light">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-0">Costo Total</h6>
                                                <p class="card-text mb-0">${(project.financials.total_cost || 0).toFixed(2)}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="card text-center bg-light">
                                            <div class="card-body p-2">
                                                <h6 class="card-title mb-0">Balance</h6>
                                                <p class="card-text mb-0">${(project.financials.balance || 0).toFixed(2)}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <h5>Tareas del Proyecto:</h5>
                                <div class="list-group list-group-flush">
                    `;

                    if (project.tasks && project.tasks.length > 0) {
                        project.tasks.forEach(task => {
                            projectHtml += `
                                    <div class="list-group-item">
                                        <h6 class="mb-1">${task.name} <small class="text-muted">(ID: ${task.id})</small></h6>
                                        <p class="mb-1"><strong>Responsable:</strong> ${task.responsible || 'Sin asignar'}</p>
                                        <p class="mb-1"><strong>Fechas:</strong> ${task.start} al ${task.end}</p>
                                        <p class="mb-1"><strong>Progreso:</strong> ${task.progress}%</p>
                                        <p class="mb-1"><strong>Costo Total Horas Hombre:</strong> ${(task.total_work_log_cost || 0).toFixed(2)}</p>
                                        <h7 class="mt-2">Trabajos Realizados:</h7>
                                        <div class="list-group list-group-flush ms-3">
                            `;

                            if (task.trabajos_realizados && task.trabajos_realizados.length > 0) {
                                task.trabajos_realizados.forEach(workLog => {
                                    projectHtml += `
                                            <div class="list-group-item list-group-item-action flex-column align-items-start py-2">
                                                <div class="d-flex w-100 justify-content-between">
                                                    <h6 class="mb-1">${workLog.type} - ${workLog.date} (${workLog.hours} horas)</h6>
                                                    <small>Costo: ${(workLog.cost || 0).toFixed(2)}</small>
                                                </div>
                                                <p class="mb-1">${workLog.description}</p>
                                                ${workLog.link ? `<small><a href="${workLog.link}" target="_blank">Ver archivos</a></small>` : ''}
                                            </div>
                                    `;
                                });
                            } else {
                                projectHtml += '<p class="text-muted ms-3">No hay trabajos realizados para esta tarea.</p>';
                            }
                            projectHtml += `
                                        </div>
                                    </div>
                            `;
                        });
                    } else {
                        projectHtml += '<p class="text-muted">No hay tareas para este proyecto.</p>';
                    }

                    projectHtml += `
                                </div>
                            </div>
                        </div>
                    `;
                    reportContainer.append(projectHtml);
                });
            },
            error: function(xhr, status, error) {
                reportContainer.empty().append('<div class="alert alert-danger">Error al cargar el reporte.</div>');
            }
        });
    }

    function fetchAndRenderWorkloadReport() {
        workloadReportBody.html('<tr><td colspan="5" class="text-center text-muted">Cargando reporte de carga de trabajo...</td></tr>');

        $.ajax({
            url: reportsApiUrl,
            method: 'GET',
            success: function(reportData) {
                workloadReportBody.empty();
                if (reportData.length === 0) {
                    workloadReportBody.append('<tr><td colspan="5" class="text-center text-info">No hay datos de carga de trabajo para mostrar.</td></tr>');
                    return;
                }

                reportData.forEach(userStats => {
                    const row = `
                        <tr>
                            <td>${userStats.user_name}</td>
                            <td>${userStats.assigned_tasks_count}</td>
                            <td>${userStats.completed_tasks_count}</td>
                            <td>${userStats.pending_tasks_count}</td>
                            <td>${userStats.total_logged_hours.toFixed(2)}</td>
                        </tr>
                    `;
                    workloadReportBody.append(row);
                });
            },
            error: function(xhr, status, error) {
                workloadReportBody.empty().append('<tr><td colspan="5" class="text-center text-danger">Error al cargar el reporte de carga de trabajo.</td></tr>');
            }
        });
    }

    // Manejador de eventos para el botón de descarga de PDF
    reportContainer.on('click', '.download-pdf-btn', function() {
        const projectId = $(this).data('project-id');
        if (projectId) {
            const projectElement = document.getElementById(`project-${projectId}`);
            if (projectElement) {
                const options = {
                    margin: 10,
                    filename: `reporte_proyecto_${projectId}.pdf`,
                    image: { type: 'jpeg', quality: 0.98 },
                    html2canvas: { scale: 2 },
                    jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' }
                };
                html2pdf().set(options).from(projectElement).save();
            } else {
                alert('No se encontró el elemento del proyecto para generar el PDF.');
            }
        } else {
            alert('No se pudo obtener el ID del proyecto para generar el PDF.');
        }
    });

    fetchAndRenderReport();
    fetchAndRenderWorkloadReport(); // Call the new function
});