$(document).ready(function() {
    const notificationBadge = $('#notification-badge');
    const notificationList = $('#notification-list');
    const notificationDropdown = $('#notificationDropdown');
    const apiUrl = 'api/notifications.php';
    const notificationSound = new Audio('sounds/notification.mp3');
    let lastUnreadCount = 0;

    function fetchNotifications() {
        $.get(apiUrl, function(notifications) {
            const unreadCount = notifications.filter(n => !n.read).length;

            if (unreadCount > lastUnreadCount) {
                notificationSound.play().catch(e => console.error("Error playing sound:", e));
            }
            lastUnreadCount = unreadCount;

            if (unreadCount > 0) {
                notificationBadge.text(unreadCount).show();
            } else {
                notificationBadge.hide();
            }

            notificationList.empty();
            if (notifications.length === 0) {
                notificationList.append('<li><a class="dropdown-item text-center text-muted" href="#">No hay notificaciones</a></li>');
            } else {
                notifications.slice(0, 5).forEach(notif => { // Show latest 5
                    const isReadClass = notif.read ? 'text-muted' : 'fw-bold';
                    const item = `
                        <li>
                            <a class="dropdown-item ${isReadClass}" href="${notif.link || '#'}">
                                <div class="small">${notif.message}</div>
                                <div class="small text-black-50">${formatTimeAgo(notif.timestamp)}</div>
                            </a>
                        </li>
                    `;
                    notificationList.append(item);
                });
                notificationList.append('<li><hr class="dropdown-divider"></li>');
                notificationList.append('<li><a class="dropdown-item text-center" href="notifications_page.php">Ver todas</a></li>');
            }
        });
    }

    function markNotificationsAsRead() {
        $.get(apiUrl, function(notifications) {
            const unreadIds = notifications.filter(n => !n.read).map(n => n.id);
            if (unreadIds.length > 0) {
                $.ajax({
                    url: apiUrl,
                    type: 'POST',
                    contentType: 'application/json',
                    data: JSON.stringify({ ids: unreadIds }),
                    success: function() {
                        notificationBadge.hide();
                        lastUnreadCount = 0; // Reset count after reading
                    }
                });
            }
        });
    }

    function formatTimeAgo(timestamp) {
        const now = new Date();
        const past = new Date(timestamp);
        const seconds = Math.floor((now - past) / 1000);

        let interval = seconds / 31536000;
        if (interval > 1) return `hace ${Math.floor(interval)} años`;
        interval = seconds / 2592000;
        if (interval > 1) return `hace ${Math.floor(interval)} meses`;
        interval = seconds / 86400;
        if (interval > 1) return `hace ${Math.floor(interval)} días`;
        interval = seconds / 3600;
        if (interval > 1) return `hace ${Math.floor(interval)} horas`;
        interval = seconds / 60;
        if (interval > 1) return `hace ${Math.floor(interval)} minutos`;
        return `hace ${Math.floor(seconds)} segundos`;
    }

    notificationDropdown.on('click', function() {
        markNotificationsAsRead();
    });

    fetchNotifications();
    setInterval(fetchNotifications, 15000); // Check for new notifications every 15 seconds
});