$(document).ready(function() {
    const apiUrl = 'api/usuarios.php';
    const profileForm = $('#profileForm');
    const messageDiv = $('#profile-message');
    const currentUserEmail = $('#currentUserEmail').val();
    let currentUserId = null;

    function loadProfile() {
        if (!currentUserEmail) {
            showMessage('No se pudo identificar al usuario.', 'danger');
            return;
        }

        $.get(apiUrl, function(users) {
            const currentUser = users.find(user => user.email === currentUserEmail);
            if (currentUser) {
                currentUserId = currentUser.id;
                populateForm(currentUser);
            } else {
                showMessage('No se encontraron los datos del perfil.', 'danger');
            }
        }).fail(function() {
            showMessage('Error al cargar el perfil.', 'danger');
        });
    }

    function populateForm(user) {
        $('#nombreCompleto').val(user.nombreCompleto);
        $('#email').val(user.email);
        $('#direccion').val(user.direccion);
        $('#telefono').val(user.telefono);
        $('#fechaNacimiento').val(user.fechaNacimiento);
        $('#foto').val(user.foto);
        $('#profileImagePreview').attr('src', user.foto || 'https://media.istockphoto.com/id/1332100919/es/vector/icono-de-hombre-icono-negro-s%C3%ADmbolo-de-persona.jpg?s=612x612&w=0&k=20&c=zf8iV9whu1NbDpw0H9A043wWjqyhPFP5m6CuesrBVFk=');
        $('#emailNotifications').prop('checked', user.email_notifications_enabled !== false);
    }

    profileForm.on('submit', function(e) {
        e.preventDefault();
        if (!currentUserId) {
            showMessage('Error: No se puede guardar el perfil sin un ID de usuario.', 'danger');
            return;
        }

        const profileData = {
            nombreCompleto: $('#nombreCompleto').val(),
            direccion: $('#direccion').val(),
            telefono: $('#telefono').val(),
            fechaNacimiento: $('#fechaNacimiento').val(),
            foto: $('#foto').val() || 'https://media.istockphoto.com/id/1332100919/es/vector/icono-de-hombre-icono-negro-s%C3%ADmbolo-de-persona.jpg?s=612x612&w=0&k=20&c=zf8iV9whu1NbDpw0H9A043wWjqyhPFP5m6CuesrBVFk=',
            email_notifications_enabled: $('#emailNotifications').is(':checked')
        };

        $.ajax({
            url: `${apiUrl}?id=${currentUserId}`,
            type: 'PUT',
            contentType: 'application/json',
            data: JSON.stringify(profileData),
            success: function() {
                showMessage('Perfil actualizado con éxito.', 'success');
                // To update the name in the menu, a reload is needed.
                // For now, we just show a message. A better UX would be to update it dynamically.
                // If the name changed, we could update the session via another API call or just reload.
                if (profileData.nombreCompleto !== $('.navbar-text').text().replace('Bienvenido, ', '')) {
                     setTimeout(() => window.location.reload(), 1500);
                }
            },
            error: function(xhr) {
                const errorMsg = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Error al guardar el perfil.';
                showMessage(errorMsg, 'danger');
            }
        });
    });

    function showMessage(message, type) {
        messageDiv.removeClass('alert-success alert-danger').addClass(`alert-${type}`).text(message).show();
        setTimeout(() => {
            messageDiv.fadeOut();
        }, 5000);
    }

    // Initial load
    loadProfile();
});