$(document).ready(function() {
    const loginForm = $('#loginForm');
    const errorMessage = $('#errorMessage');

    loginForm.on('submit', function(e) {
        e.preventDefault();
        errorMessage.hide();

        const email = $('#email').val();
        const password = $('#password').val();

        $.ajax({
            url: 'api/login.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ email: email, password: password }),
            success: function(response) {
                if (response.success) {
                    // Redirect to index.php which will be the protected page
                    window.location.href = 'home.php'; 
                }
            },
            error: function(jqXHR) {
                let message = 'Error al intentar iniciar sesión.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                    message = jqXHR.responseJSON.message;
                }
                errorMessage.text(message).show();
            }
        });
    });
});