$(document).ready(function() {
    const conversationsList = $('#conversations-list-widget');
    const chatArea = $('#chat-area-widget');
    const currentUserEmail = $('#userEmail').val();
    let usersMap = {};

    function initialLoad() {
        $.get('api/usuarios.php', function(users) {
            usersMap = users.reduce((map, user) => {
                map[user.email] = user.nombreCompleto;
                return map;
            }, {});
            loadConversations(usersMap);
        });
    }

    function loadConversations(usersMap) {
        $.get('api/conversations.php', function(conversations) {
            conversationsList.empty();
            conversations.forEach(function(conv) {
                let convName;
                if (conv.type === 'group') {
                    convName = conv.name;
                } else {
                    const otherUserEmail = conv.participants.find(p => p !== currentUserEmail);
                    convName = otherUserEmail && usersMap[otherUserEmail] ? usersMap[otherUserEmail] : otherUserEmail || 'Usuario no disponible';
                }

                const conversationItem = $(`<div class="conversation-item-widget" data-id="${conv.id}" data-name="${convName}">${convName}</div>`);
                conversationItem.click(function() {
                    window.selectConversationWidget(conv.id, convName);
                    conversationsList.hide();
                    chatArea.show();
                });
                conversationsList.append(conversationItem);
            });
        });
    }

    // Widget visibility
    $('#open-chat-widget').click(function() {
        $('#chat-widget-container').css('display', 'flex');
        initialLoad();
    });

    $('#close-chat-widget').click(function() {
        $('#chat-widget-container').hide();
    });

    $('#back-to-conversations').click(function() {
        chatArea.hide();
        conversationsList.show();
    });

});