$(document).ready(function() {
    const apiUrl = 'api/clients.php';
    const clientModal = new bootstrap.Modal(document.getElementById('clientModal'));
    const clientForm = $('#clientForm');
    const clientTableBody = $('#clientTableBody');

    let allClients = [];

    function init() {
        loadClients();
        setupEventListeners();
    }

    function loadClients() {
        $.get(apiUrl, function(clients) {
            allClients = clients;
            renderClients();
        }).fail(function() {
            clientTableBody.html('<tr><td colspan="4" class="text-center text-danger">Error al cargar los clientes.</td></tr>');
        });
    }

    function renderClients() {
        clientTableBody.empty();
        if (allClients && allClients.length > 0) {
            allClients.forEach(client => {
                const clientRow = `
                    <tr data-id="${client.id}">
                        <td><strong>${client.nombre_razon_social}</strong><br><small class="text-muted">RUC: ${client.ruc || 'N/A'}</small></td>
                        <td>${client.pais || ''} / ${client.ciudad || ''}</td>
                        <td><strong>${client.nombre_contacto || 'N/A'}</strong><br><small class="text-muted">${client.correo_contacto || ''}</small></td>
                        <td>
                            <button class="btn btn-sm btn-info btn-edit">Editar</button>
                            <button class="btn btn-sm btn-danger btn-delete">Eliminar</button>
                        </td>
                    </tr>
                `;
                clientTableBody.append(clientRow);
            });
        } else {
            clientTableBody.html('<tr><td colspan="4" class="text-center">No hay clientes registrados.</td></tr>');
        }
    }

    function setupEventListeners() {
        $('[data-bs-target="#clientModal"]').on('click', function() {
            showModal(null);
        });

        clientForm.on('submit', function(e) {
            e.preventDefault();
            const clientId = $('#clientId').val();
            const clientData = {
                nombre_razon_social: $('#clientName').val(),
                ruc: $('#clientRuc').val(),
                direccion: $('#clientAddress').val(),
                ciudad: $('#clientCity').val(),
                pais: $('#clientCountry').val(),
                correo_electronico: $('#clientEmail').val(),
                numero_telefono: $('#clientPhone').val(),
                nombre_contacto: $('#contactName').val(),
                correo_contacto: $('#contactEmail').val(),
                telefono_contacto: $('#contactPhone').val(),
            };

            $.ajax({
                url: clientId ? `${apiUrl}?id=${clientId}` : apiUrl,
                type: clientId ? 'PUT' : 'POST',
                contentType: 'application/json',
                data: JSON.stringify(clientData),
                success: function() {
                    clientModal.hide();
                    loadClients();
                },
                error: function() { alert('Error al guardar el cliente.'); }
            });
        });

        clientTableBody.on('click', '.btn-edit', function() {
            const clientId = $(this).closest('tr').data('id');
            const client = allClients.find(c => c.id === clientId);
            if (client) showModal(client);
        });

        clientTableBody.on('click', '.btn-delete', function() {
            const clientId = $(this).closest('tr').data('id');
            if (confirm('¿Estás seguro de eliminar este cliente?')) {
                $.ajax({
                    url: `${apiUrl}?id=${clientId}`,
                    type: 'DELETE',
                    success: function() { loadClients(); },
                    error: function() { alert('Error al eliminar el cliente.'); }
                });
            }
        });

        $('#btnDeleteClient').on('click', function() {
            const clientId = $('#clientId').val();
            if (clientId && confirm('¿Estás seguro de eliminar este cliente?')) {
                $.ajax({
                    url: `${apiUrl}?id=${clientId}`,
                    type: 'DELETE',
                    success: function() {
                        clientModal.hide();
                        loadClients();
                    },
                    error: function() { alert('Error al eliminar el cliente.'); }
                });
            }
        });
    }

    function showModal(client) {
        clientForm[0].reset();
        if (client) {
            $('#clientModalLabel').text('Editar Cliente');
            $('#clientId').val(client.id);
            $('#clientName').val(client.nombre_razon_social);
            $('#clientRuc').val(client.ruc);
            $('#clientAddress').val(client.direccion);
            $('#clientCity').val(client.ciudad);
            $('#clientCountry').val(client.pais);
            $('#clientEmail').val(client.correo_electronico);
            $('#clientPhone').val(client.numero_telefono);
            $('#contactName').val(client.nombre_contacto);
            $('#contactEmail').val(client.correo_contacto);
            $('#contactPhone').val(client.telefono_contacto);
            $('#btnDeleteClient').show();
        } else {
            $('#clientModalLabel').text('Nuevo Cliente');
            $('#clientId').val('');
            $('#btnDeleteClient').hide();
        }
        clientModal.show();
    }

    init();
});