$(document).ready(function() {
    const chatTitle = $('#chat-title-widget');
    const chatBox = $('#chat-box-widget');
    const chatForm = $('#chat-form-widget');
    const messageInput = $('#message-input-widget');
    let currentConversationId = null;
    let messageInterval = null;

    window.selectConversationWidget = function(conversationId, conversationName) {
        currentConversationId = conversationId;
        chatTitle.text(conversationName);

        loadMessages();
        if (messageInterval) clearInterval(messageInterval);
        messageInterval = setInterval(loadMessages, 3000);
    }

    function loadMessages() {
        if (!currentConversationId) return;

        $.get(`api/chat.php?conversation_id=${currentConversationId}`, function(messages) {
            chatBox.empty();
            messages.forEach(function(msg) {
                const messageElement = $('<div class="message"></div>');
                const senderElement = $('<div class="sender"></div>').text(msg.sender_name);
                const messageTextElement = $('<div class="message-text"></div>').text(msg.message);
                const timestampElement = $('<div class="timestamp"></div>').text(msg.timestamp);

                messageElement.append(senderElement, messageTextElement, timestampElement);
                chatBox.append(messageElement);
            });
            chatBox.scrollTop(chatBox[0].scrollHeight);
        });
    }

    chatForm.submit(function(e) {
        e.preventDefault();
        const message = messageInput.val();
        if (message.trim() === '' || !currentConversationId) return;

        $.ajax({
            url: 'api/chat.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ message: message, conversation_id: currentConversationId }),
            success: function() {
                messageInput.val('');
                loadMessages();
            },
            error: function() {
                alert('Error al enviar el mensaje.');
            }
        });
    });

    // Stop polling when widget is closed
    $('#close-chat-widget').click(function() {
        if (messageInterval) clearInterval(messageInterval);
        currentConversationId = null;
    });
});