$(document).ready(function() {
    const chatHeader = $('#chat-header');
    const chatTitle = $('#chat-title');
    const chatBox = $('#chat-box');
    const chatForm = $('#chat-form');
    const messageInput = $('#message-input');
    let currentConversationId = null;
    let messageInterval = null;

    window.selectConversation = function(conversationId, conversationName) {
        currentConversationId = conversationId;
        chatTitle.text(conversationName);
        chatHeader.show();
        chatForm.show();
        chatBox.empty();

        loadMessages();
        if (messageInterval) clearInterval(messageInterval);
        messageInterval = setInterval(loadMessages, 3000);
    }

    function loadMessages() {
        if (!currentConversationId) return;

        $.get(`api/chat.php?conversation_id=${currentConversationId}`, function(messages) {
            chatBox.empty();
            messages.forEach(function(msg) {
                const messageElement = $('<div class="message d-flex align-items-start"></div>'); // Added d-flex and align-items-start
                const senderPhoto = $('<img class="rounded-circle me-2" style="width: 40px; height: 40px; object-fit: cover;"></div>')
                                    .attr('src', msg.sender_photo || 'https://via.placeholder.com/50') // Use sender_photo
                                    .attr('alt', msg.sender_name);
                const messageContent = $('<div></div>');
                const senderElement = $('<div class="sender"></div>').text(msg.sender_name);
                const messageTextElement = $('<div class="message-text"></div>').text(msg.message);
                const timestampElement = $('<div class="timestamp"></div>').text(msg.timestamp);

                messageContent.append(senderElement, messageTextElement, timestampElement);
                messageElement.append(senderPhoto, messageContent);
                chatBox.append(messageElement);
            });
            chatBox.scrollTop(chatBox[0].scrollHeight);
        });
    }

    chatForm.submit(function(e) {
        e.preventDefault();
        const message = messageInput.val();
        if (message.trim() === '' || !currentConversationId) return;

        $.ajax({
            url: 'api/chat.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({ message: message, conversation_id: currentConversationId }),
            success: function() {
                messageInput.val('');
                loadMessages();
            },
            error: function() {
                alert('Error al enviar el mensaje.');
            }
        });
    });
});