$(document).ready(function() {
    const changePasswordForm = $('#changePasswordForm');
    const messageDiv = $('#message');

    changePasswordForm.on('submit', function(e) {
        e.preventDefault();
        messageDiv.hide().removeClass('alert-success alert-danger');

        const currentPassword = $('#currentPassword').val();
        const newPassword = $('#newPassword').val();
        const confirmNewPassword = $('#confirmNewPassword').val();

        if (newPassword !== confirmNewPassword) {
            messageDiv.text('La nueva contraseña y su confirmación no coinciden.').addClass('alert-danger').show();
            return;
        }

        if (newPassword.length < 6) { // Basic validation
            messageDiv.text('La nueva contraseña debe tener al menos 6 caracteres.').addClass('alert-danger').show();
            return;
        }

        $.ajax({
            url: 'api/change_password.php',
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify({
                current_password: currentPassword,
                new_password: newPassword
            }),
            success: function(response) {
                messageDiv.text(response.message || 'Contraseña cambiada exitosamente.').addClass('alert-success').show();
                changePasswordForm[0].reset();
            },
            error: function(jqXHR) {
                let message = 'Error al cambiar la contraseña.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                    message = jqXHR.responseJSON.message;
                }
                messageDiv.text(message).addClass('alert-danger').show();
            }
        });
    });
});