<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard de Proyectos - Dunamis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Dashboard de Proyectos</h2>
            <?php if ($_SESSION['user_role'] === 'admin' || $_SESSION['user_role'] === 'project_manager'): ?>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#projectModal">
                    &#43; Nuevo Proyecto
                </button>
            <?php endif; ?>
        </div>
        <div id="project-list" class="row gy-4">
            <!-- Los proyectos se cargarán aquí -->
        </div>
    </div>

    <!-- Modal para Añadir/Editar Proyecto -->
    <div class="modal fade" id="projectModal" tabindex="-1" aria-labelledby="projectModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="projectModalLabel">Nuevo Proyecto</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="projectForm">
                        <ul class="nav nav-tabs" id="projectTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="details-tab" data-bs-toggle="tab" data-bs-target="#project-details-tab" type="button" role="tab" aria-controls="project-details-tab" aria-selected="true">Detalles</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="activity-log-tab" data-bs-toggle="tab" data-bs-target="#activity-log-pane" type="button" role="tab" aria-controls="activity-log-pane" aria-selected="false">Log de Actividad</button>
                            </li>
                        </ul>
                        <div class="tab-content pt-3" id="projectTabContent">
                            <div class="tab-pane fade show active" id="project-details-tab" role="tabpanel" aria-labelledby="details-tab">
                                <input type="hidden" id="projectId">
                                <div class="mb-3">
                                    <label for="projectName" class="form-label">Nombre del Proyecto</label>
                                    <input type="text" class="form-control" id="projectName" required>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="projectStart" class="form-label">Fecha de Inicio</label>
                                        <input type="date" class="form-control" id="projectStart" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="projectEnd" class="form-label">Fecha de Fin (Términos)</label>
                                        <input type="date" class="form-control" id="projectEnd" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="projectManager" class="form-label">Gerente de Proyecto</label>
                                        <select class="form-select" id="projectManager"></select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="projectSponsor" class="form-label">Sponsor del Proyecto</label>
                                        <select class="form-select" id="projectSponsor"></select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="projectClient" class="form-label">Cliente</label>
                                    <select class="form-select" id="projectClient" required>
                                        <option value="" disabled selected>Cargando...</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="projectObjectives" class="form-label">Objetivos</label>
                                    <textarea class="form-control" id="projectObjectives" rows="3"></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="projectDeliverables" class="form-label">Entregables</label>
                                    <textarea class="form-control" id="projectDeliverables" rows="3"></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="projectStatus" class="form-label">Estado del Proyecto</label>
                                        <select class="form-select" id="projectStatus">
                                            <option value="planificacion">Planificación</option>
                                            <option value="pendiente de aprobacion">Pendiente de Aprobación</option>
                                            <option value="activos">Activo</option>
                                            <option value="en espera">En Espera</option>
                                            <option value="completado">Completado</option>
                                            <option value="cancelado">Cancelado</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="projectBudget" class="form-label">Presupuesto</label>
                                        <input type="text" class="form-control" id="projectBudget">
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="activity-log-pane" role="tabpanel" aria-labelledby="activity-log-tab">
                                <div id="activityLogList" class="list-group" style="max-height: 400px; overflow-y: auto;">
                                    <!-- Activity log items will be loaded here -->
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnDeleteProject" class="btn btn-danger me-auto" style="display: none;">Eliminar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="projectForm">Guardar Proyecto</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="js/notifications.js"></script>
    <script src="js/dashboard.js"></script>

</body>
</html>