<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inicio - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4">Bienvenido, <?php echo htmlspecialchars($_SESSION['user_name']); ?></h2>
        <input type="hidden" id="userEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">

        <div class="row">
            <div class="col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light text-dark">
                        <h5 class="mb-0">Mis Proyectos</h5>
                    </div>
                    <div class="card-body">
                        <div id="my-projects-list">
                            <!-- Projects will be loaded here -->
                            <p class="text-muted">Cargando proyectos...</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light text-dark">
                        <h5 class="mb-0">Mis Tareas</h5>
                    </div>
                    <div class="card-body">
                        <div id="my-tasks-list">
                            <!-- Tasks will be loaded here -->
                            <p class="text-muted">Cargando tareas...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light text-dark">
                        <h5 class="mb-0">Feed de Actividad Reciente</h5>
                    </div>
                    <div class="card-body" style="max-height: 400px; overflow-y: auto;">
                        <div id="activity-feed-list" class="list-group list-group-flush">
                            <!-- Activity feed will be loaded here -->
                            <p class="text-muted">Cargando actividad...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <h3 class="mt-4 mb-3">Estadísticas Generales</h3>
        <div class="row" id="general-stats">
            <!-- Las estadísticas se cargarán aquí -->
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Total Proyectos</h5>
                        <p class="card-text display-4" id="stat-total-projects">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Proyectos Activos</h5>
                        <p class="card-text display-4" id="stat-active-projects">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Proyectos Completados</h5>
                        <p class="card-text display-4" id="stat-completed-projects">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Total Tareas</h5>
                        <p class="card-text display-4" id="stat-total-tasks">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Tareas Pendientes</h5>
                        <p class="card-text display-4" id="stat-pending-tasks">0</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Horas Registradas</h5>
                        <p class="card-text display-4" id="stat-total-hours">0</p>
                    </div>
                </div>
            </div>
        </div>

        <h3 class="mt-4 mb-3">Gráficos</h3>
        <div class="row">
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Proyectos por Estado</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="projectsStatusChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Horas por Tipo de Trabajo</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="workLogTypeChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mb-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Actividad Reciente</h5>
                        <div class="d-flex align-items-center">
                            <input type="date" id="activityStartDate" class="form-control form-control-sm me-2" style="width: auto;">
                            <span class="text-white me-2">-</span>
                            <input type="date" id="activityEndDate" class="form-control form-control-sm" style="width: auto;">
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="recentActivityChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
    <script src="js/home.js"></script>
</body>
</html>