<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Clientes - Dunamis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Listado de Clientes</h2>
            <?php if ($_SESSION['user_role'] === 'admin' || $_SESSION['user_role'] === 'project_manager'): ?>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#clientModal">&#43; Nuevo Cliente</button>
            <?php endif; ?>
        </div>
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Nombre / Razón Social</th>
                        <th>País / Ciudad</th>
                        <th>Contacto Principal</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="clientTableBody"></tbody>
            </table>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="clientModal" tabindex="-1" aria-labelledby="clientModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="clientModalLabel">Nuevo Cliente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="clientForm">
                        <input type="hidden" id="clientId">
                        <div class="row mb-3">
                            <div class="col-md-8">
                                <label for="clientName" class="form-label">Nombre o Razón Social</label>
                                <input type="text" class="form-control" id="clientName" required>
                            </div>
                            <div class="col-md-4">
                                <label for="clientRuc" class="form-label">RUC</label>
                                <input type="text" class="form-control" id="clientRuc">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="clientAddress" class="form-label">Dirección</label>
                            <input type="text" class="form-control" id="clientAddress">
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="clientCity" class="form-label">Ciudad</label>
                                <input type="text" class="form-control" id="clientCity">
                            </div>
                            <div class="col-md-6">
                                <label for="clientCountry" class="form-label">País</label>
                                <input type="text" class="form-control" id="clientCountry">
                            </div>
                        </div>
                        <hr>
                        <h6 class="text-primary">Datos de la Empresa</h6>
                        <div class="row mb-3">
                             <div class="col-md-6">
                                <label for="clientEmail" class="form-label">Correo Electrónico</label>
                                <input type="email" class="form-control" id="clientEmail">
                            </div>
                            <div class="col-md-6">
                                <label for="clientPhone" class="form-label">Número de Teléfono</label>
                                <input type="tel" class="form-control" id="clientPhone">
                            </div>
                        </div>
                        <hr>
                        <h6 class="text-primary">Datos del Contacto</h6>
                         <div class="mb-3">
                            <label for="contactName" class="form-label">Nombre del Contacto</label>
                            <input type="text" class="form-control" id="contactName">
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="contactEmail" class="form-label">Correo del Contacto</label>
                                <input type="email" class="form-control" id="contactEmail">
                            </div>
                            <div class="col-md-6">
                                <label for="contactPhone" class="form-label">Teléfono del Contacto</label>
                                <input type="tel" class="form-control" id="contactPhone">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnDeleteClient" class="btn btn-danger me-auto" style="display: none;">Eliminar</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary" form="clientForm">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="js/notifications.js"></script>
    <script src="js/clientes.js"></script>
</body>
</html>