<!-- Chat Widget -->
<div id="chat-widget-container" class="chat-widget-container">
    <div class="chat-widget-header" id="chat-widget-header">
        <h4>Chat</h4>
        <button id="close-chat-widget" class="btn-close"></button>
    </div>
    <div class="chat-widget-body">
        <div class="conversations-list-widget" id="conversations-list-widget">
            <!-- Conversation list will be loaded here -->
        </div>
        <div class="chat-area-widget" id="chat-area-widget" style="display: none;">
            <div class="chat-header-widget">
                <button id="back-to-conversations" class="btn btn-sm btn-outline-secondary">< Volver</button>
                <h5 id="chat-title-widget"></h5>
            </div>
            <div class="chat-box-widget" id="chat-box-widget">
                <!-- Messages will be loaded here -->
            </div>
            <form id="chat-form-widget">
                <div class="input-group">
                    <input type="text" id="message-input-widget" class="form-control" placeholder="Escribe un mensaje..." required>
                    <button type="submit" class="btn btn-primary">Enviar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Floating Chat Button -->
<button id="open-chat-widget" class="btn btn-primary rounded-circle chat-widget-button">Chat</button>

<style>
.chat-widget-button {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 60px;
    height: 60px;
    z-index: 999;
}

.chat-widget-container {
    position: fixed;
    bottom: 100px;
    right: 20px;
    width: 350px;
    max-height: 500px;
    background-color: white;
    border: 1px solid #ccc;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0,0,0,0.2);
    display: none; /* Hidden by default */
    flex-direction: column;
    z-index: 1000;
}

.chat-widget-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 15px;
    border-bottom: 1px solid #eee;
    background-color: #f8f9fa;
    border-top-left-radius: 10px;
    border-top-right-radius: 10px;
}

.chat-widget-body {
    display: flex;
    flex-grow: 1;
    overflow: hidden;
}

.conversations-list-widget {
    width: 100%;
    overflow-y: auto;
}

.chat-area-widget {
    width: 100%;
    display: flex;
    flex-direction: column;
}

.chat-header-widget {
    display: flex;
    align-items: center;
    padding: 10px;
    border-bottom: 1px solid #eee;
}

#chat-title-widget {
    margin: 0;
    margin-left: 10px;
    font-size: 1rem;
}

.chat-box-widget {
    flex-grow: 1;
    overflow-y: auto;
    padding: 10px;
}

#chat-form-widget {
    padding: 10px;
}

.conversation-item-widget {
    padding: 10px 15px;
    cursor: pointer;
    border-bottom: 1px solid #eee;
}

.conversation-item-widget:hover {
    background-color: #f0f0f0;
}

</style>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="js/conversations_widget.js"></script>
<script src="js/chat_widget.js"></script>
