<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header('Location: login.html');
    exit();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat - Dunamis Proyectos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        .chat-container {
            display: flex;
            height: calc(100vh - 120px); /* Adjusted height */
        }
        .sidebar {
            width: 300px;
            border-right: 1px solid #ccc;
            display: flex;
            flex-direction: column;
        }
        .sidebar-list {
            flex-grow: 1;
            overflow-y: auto;
        }
        .chat-area {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            padding-left: 15px;
        }
        #chat-box {
            flex-grow: 1;
            overflow-y: auto;
            border: 1px solid #eee;
            padding: 15px;
            background-color: #f9f9f9;
        }
        .message {
            margin-bottom: 15px;
            padding: 10px;
            border-radius: 8px;
            background-color: #fff;
            border: 1px solid #ddd;
        }
        .message .sender {
            font-weight: bold;
            color: #0d6efd;
        }
        .message .timestamp {
            font-size: 0.8em;
            color: #999;
            float: right;
        }
        .sidebar-item {
            padding: 12px 15px;
            cursor: pointer;
            border-bottom: 1px solid #eee;
        }
        .sidebar-item:hover, .sidebar-item.active {
            background-color: #e9ecef;
        }
        #chat-form {
            padding-top: 15px;
        }
    </style>
</head>
<body>
    <?php include 'menu.php'; ?>

    <div class="container mt-4">
        <div class="chat-container">
            <div class="sidebar">
                <div class="p-3">
                    <h5>Conversaciones
                        <button type="button" class="btn btn-primary btn-sm float-end" data-bs-toggle="modal" data-bs-target="#newGroupModal">+ Crear Grupo</button>
                    </h5>
                </div>
                <div class="sidebar-list" id="groups-list">
                    <!-- Conversation list will be loaded here -->
                </div>
                <div class="p-3">
                    <h5>Usuarios</h5>
                </div>
                <div class="sidebar-list" id="users-list">
                    <!-- User list will be loaded here -->
                </div>
            </div>
            <div class="chat-area">
                <div class="p-3 border-bottom" id="chat-header" style="display: none;">
                    <h5 id="chat-title"></h5>
                </div>
                <div id="chat-box">
                    <div class="text-center text-muted">Selecciona un usuario o grupo para empezar a chatear.</div>
                </div>
                <form id="chat-form" style="display: none;">
                    <div class="input-group">
                        <input type="text" id="message-input" class="form-control" placeholder="Escribe un mensaje..." required>
                        <button type="submit" class="btn btn-primary">Enviar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- New Group Modal -->
    <div class="modal fade" id="newGroupModal" tabindex="-1" aria-labelledby="newGroupModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newGroupModalLabel">Nuevo Grupo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="newGroupForm">
                        <div class="mb-3">
                            <label for="groupName" class="form-label">Nombre del Grupo</label>
                            <input type="text" id="groupName" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="userSelect" class="form-label">Participantes</label>
                            <select id="userSelect" class="form-select" multiple required>
                                <!-- User list will be loaded here -->
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Crear Grupo</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Group Modal -->
    <div class="modal fade" id="editGroupModal" tabindex="-1" aria-labelledby="editGroupModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editGroupModalLabel">Editar Grupo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editGroupForm">
                        <input type="hidden" id="editGroupId">
                        <div class="mb-3">
                            <label for="editGroupName" class="form-label">Nombre del Grupo</label>
                            <input type="text" id="editGroupName" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label for="editGroupPhotoUrl" class="form-label">URL de la Foto del Grupo (Opcional)</label>
                            <input type="url" id="editGroupPhotoUrl" class="form-control" placeholder="https://example.com/group_photo.jpg">
                        </div>
                        <div class="mb-3">
                            <label for="editUserSelect" class="form-label">Participantes</label>
                            <select id="editUserSelect" class="form-select" multiple required>
                                <!-- User list will be loaded here -->
                            </select>
                        </div>
                        <div class="modal-footer">
                            <button type="button" id="btnDeleteGroup" class="btn btn-danger me-auto">Eliminar Grupo</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                            <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/notifications.js"></script>
    <script src="js/chat.js"></script>
    <script src="js/conversations.js"></script>
    <input type="hidden" id="userEmail" value="<?php echo htmlspecialchars($_SESSION['user_email']); ?>">
</body>
</html>