<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_email'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No autenticado.']);
    exit();
}

$notificationsFile = '../data/notifications.json';
$method = $_SERVER['REQUEST_METHOD'];
$userEmail = $_SESSION['user_email'];

function getNotifications($filePath) {
    if (!file_exists($filePath) || filesize($filePath) === 0) {
        return [];
    }
    $fileContent = file_get_contents($filePath);
    $notifications = json_decode($fileContent, true);
    return json_last_error() === JSON_ERROR_NONE ? $notifications : [];
}

function saveNotifications($filePath, $notifications) {
    $fileHandle = fopen($filePath, 'w');
    if (flock($fileHandle, LOCK_EX)) {
        fwrite($fileHandle, json_encode($notifications, JSON_PRETTY_PRINT));
        flock($fileHandle, LOCK_UN);
    }
    fclose($fileHandle);
}

switch ($method) {
    case 'GET':
        $allNotifications = getNotifications($notificationsFile);
        $userNotifications = array_filter($allNotifications, function($notif) use ($userEmail) {
            return isset($notif['user_email']) && $notif['user_email'] === $userEmail;
        });

        // Sort by timestamp descending
        usort($userNotifications, function($a, $b) {
            return strtotime($b['timestamp']) - strtotime($a['timestamp']);
        });

        echo json_encode(array_values($userNotifications));
        break;

    case 'POST': // Used to mark notifications as read
        $input = json_decode(file_get_contents('php://input'), true);
        $notificationIds = $input['ids'] ?? [];

        if (empty($notificationIds)) {
            http_response_code(400);
            echo json_encode(['error' => 'No se proporcionaron IDs de notificación.']);
            exit;
        }

        $allNotifications = getNotifications($notificationsFile);
        $updated = false;

        foreach ($allNotifications as $key => $notification) {
            if (in_array($notification['id'], $notificationIds) && $notification['user_email'] === $userEmail) {
                $allNotifications[$key]['read'] = true;
                $updated = true;
            }
        }

        if ($updated) {
            saveNotifications($notificationsFile, $allNotifications);
        }

        echo json_encode(['success' => true, 'message' => 'Notificaciones marcadas como leídas.']);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method Not Allowed']);
        break;
}
?>