<?php

if (!function_exists('createNotification')) {
    function createNotification($filePath, $userEmail, $message, $link) {
        
        function getNotificationsHelper($path) {
            if (!file_exists($path) || filesize($path) === 0) {
                return [];
            }
            $content = file_get_contents($path);
            $notifications = json_decode($content, true);
            return json_last_error() === JSON_ERROR_NONE ? $notifications : [];
        }

        function saveNotificationsHelper($path, $notifications) {
            $handle = fopen($path, 'w');
            if (flock($handle, LOCK_EX)) {
                fwrite($handle, json_encode($notifications, JSON_PRETTY_PRINT));
                flock($handle, LOCK_UN);
            }
            fclose($handle);
        }

        $notifications = getNotificationsHelper($filePath);
        $newNotification = [
            'id' => uniqid('notif_'), 'user_email' => $userEmail, 'message' => $message,
            'link' => $link, 'timestamp' => date('Y-m-d H:i:s'), 'read' => false
        ];
        $notifications[] = $newNotification;
        saveNotificationsHelper($filePath, $notifications);
    }
}