<?php
session_start();
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? '';
$password = $input['password'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email y contraseña son requeridos.']);
    exit;
}

$usersFilePath = __DIR__ . '/../data/usuarios.json';
if (!file_exists($usersFilePath)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error interno del servidor.']);
    exit;
}

$users = json_decode(file_get_contents($usersFilePath), true);
$userFound = null;

foreach ($users as $user) {
    if (isset($user['email']) && strtolower($user['email']) === strtolower($email)) {
        $userFound = $user;
        break;
    }
}

if ($userFound && isset($userFound['password']) && password_verify($password, $userFound['password'])) {
    // Login successful
    $_SESSION['user_email'] = $userFound['email'];
    $_SESSION['user_name'] = $userFound['nombreCompleto'];
    $_SESSION['user_role'] = $userFound['role'] ?? 'team_member'; // Default to team_member if role not set
    echo json_encode(['success' => true]);
} else {
    // Login failed
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Credenciales inválidas.']);
}
?>