<?php
session_start();
header('Content-Type: application/json');

// --- PERMISSION CHECK FUNCTION (Copied from usuarios.php) ---
function checkPermission($requiredRole) {
    if (!isset($_SESSION['user_role'])) {
        http_response_code(401); // Unauthorized
        echo json_encode(['error' => 'No autenticado.']);
        exit();
    }

    $userRole = $_SESSION['user_role'];
    $rolesHierarchy = [
        'admin' => 3,
        'project_manager' => 2,
        'team_member' => 1
    ];

    if (!isset($rolesHierarchy[$userRole]) || !isset($rolesHierarchy[$requiredRole])) {
        http_response_code(500); // Internal Server Error - invalid role configured
        echo json_encode(['error' => 'Error de configuración de roles.']);
        exit();
    }

    if ($rolesHierarchy[$userRole] < $rolesHierarchy[$requiredRole]) {
        http_response_code(403); // Forbidden
        echo json_encode(['error' => 'Permiso denegado. Rol insuficiente.']);
        exit();
    }
}
// --- END PERMISSION CHECK FUNCTION ---

checkPermission('team_member'); // Apply permission check for all operations in this API

$userEmail = $_SESSION['user_email'];
$usersFilePath = '../data/usuarios.json';

$input = json_decode(file_get_contents('php://input'), true);
$currentPassword = $input['current_password'] ?? '';
$newPassword = $input['new_password'] ?? '';

if (empty($currentPassword) || empty($newPassword)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Todos los campos son requeridos.']);
    exit();
}

// Read users data
if (!file_exists($usersFilePath)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error interno del servidor: archivo de usuarios no encontrado.']);
    exit();
}
$users = json_decode(file_get_contents($usersFilePath), true);
if ($users === null) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error interno del servidor: datos de usuarios corruptos.']);
    exit();
}

$userFound = false;
foreach ($users as $key => $user) {
    if (isset($user['email']) && $user['email'] === $userEmail) {
        // Verify current password
        if (password_verify($currentPassword, $user['password'])) {
            // Hash new password
            $users[$key]['password'] = password_hash($newPassword, PASSWORD_DEFAULT);
            
            // Save updated users data
            $fileHandle = fopen($usersFilePath, 'w');
            if (flock($fileHandle, LOCK_EX)) {
                fwrite($fileHandle, json_encode($users, JSON_PRETTY_PRINT));
                flock($fileHandle, LOCK_UN);
            }
            fclose($fileHandle);

            echo json_encode(['success' => true, 'message' => 'Contraseña cambiada exitosamente.']);
            $userFound = true;
            break;
        } else {
            http_response_code(401);
            echo json_encode(['success' => false, 'message' => 'Contraseña actual incorrecta.']);
            $userFound = true; // User found, but password incorrect
            break;
        }
    }
}

if (!$userFound) {
    http_response_code(404);
    echo json_encode(['success' => false, 'message' => 'Usuario no encontrado.']);
}
?>