<?php

if (!function_exists('logActivity')) {
    /**
     * Logs an activity for a specific project.
     *
     * @param string $projectId The ID of the project.
     * @param string $action A description of the action performed.
     */
    function logActivity($projectId, $action) {
        if (!isset($_SESSION['user_name']) || !isset($_SESSION['user_email'])) {
            return; // Cannot log if user is not identified
        }

        $logFilePath = __DIR__ . '/../data/activity_log.json';

        // Helper to read logs
        $logs = [];
        if (file_exists($logFilePath) && filesize($logFilePath) > 0) {
            $logs = json_decode(file_get_contents($logFilePath), true) ?: [];
        }

        $newLogEntry = [
            'id' => uniqid('log_'),
            'project_id' => $projectId,
            'user_name' => $_SESSION['user_name'],
            'user_email' => $_SESSION['user_email'],
            'action' => $action,
            'timestamp' => date('Y-m-d H:i:s')
        ];

        $logs[] = $newLogEntry;

        // Save logs
        file_put_contents($logFilePath, json_encode($logs, JSON_PRETTY_PRINT), LOCK_EX);
    }
}