<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_email'])) {
    http_response_code(401);
    echo json_encode(['error' => 'No autenticado.']);
    exit();
}

$projectId = isset($_GET['project_id']) ? $_GET['project_id'] : null;

$logFilePath = '../data/activity_log.json';
$allLogs = [];
if (file_exists($logFilePath) && filesize($logFilePath) > 0) {
    $allLogs = json_decode(file_get_contents($logFilePath), true) ?: [];
}

$outputLogs = [];
if ($projectId) {
    $outputLogs = array_filter($allLogs, function($log) use ($projectId) {
        return isset($log['project_id']) && $log['project_id'] === $projectId;
    });
} else {
    $outputLogs = $allLogs;
}

// Sort logs by timestamp descending
usort($outputLogs, function($a, $b) {
    return strtotime($b['timestamp']) - strtotime($a['timestamp']);
});

echo json_encode(array_values($outputLogs));

?>