<?php
header('Content-Type: application/json');

// 1. Directorio de destino para los archivos.
$upload_dir = 'uploads/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

// 2. Validar que se haya subido un archivo.
if (!isset($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) {
    header("HTTP/1.1 400 Bad Request");
    echo json_encode(['status' => 'error', 'message' => 'No se ha seleccionado ningún archivo.']);
    exit;
}

$file = $_FILES['file'];

// 3. Comprobar si hubo errores durante la subida.
if ($file['error'] !== UPLOAD_ERR_OK) {
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode(['status' => 'error', 'message' => 'Error en la subida del archivo. Código: ' . $file['error']]);
    exit;
}

// 4. Generar un nombre de archivo único para evitar sobreescrituras.
$file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
$unique_filename = uniqid('file_', true) . '.' . $file_extension;
$destination = $upload_dir . $unique_filename;

// 5. Mover el archivo a su destino final.
if (move_uploaded_file($file['tmp_name'], $destination)) {
    // 6. Devolver la información del archivo en formato JSON.
    echo json_encode([
        'status' => 'success',
        'original_name' => $file['name'],
        'url' => $destination
    ]);
} else {
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode(['status' => 'error', 'message' => 'No se pudo mover el archivo subido.']);
}
?>