<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>
    <div class="container">
        <h1>Generación de Reportes</h1>

        <div class="report-section">
            <h2>Ficha de Profesional</h2>
            <p>Genera una ficha imprimible con la información detallada de un profesional.</p>
            <form action="reporte_profesional.php" method="get" target="_blank">
                <select id="profesional-report-select" name="id" required>
                    <option value="">-- Seleccionar Profesional --</option>
                    <!-- Opciones cargadas por JS -->
                </select>
                <button type="submit">Generar Reporte</button>
            </form>
        </div>

        <div class="report-section">
            <h2>Ficha de Paciente</h2>
            <p>Genera una ficha imprimible con el historial clínico completo de un paciente.</p>
            <form action="reporte_paciente.php" method="get" target="_blank">
                <select id="paciente-report-select" name="id" required>
                    <option value="">-- Seleccionar Paciente --</option>
                    <!-- Opciones cargadas por JS -->
                </select>
                <label for="start_date_paciente">Desde:</label>
                <input type="date" id="start_date_paciente" name="start_date">
                <label for="end_date_paciente">Hasta:</label>
                <input type="date" id="end_date_paciente" name="end_date">
                <button type="submit">Generar Reporte</button>
            </form>
        </div>

        <div class="report-section">
            <h2>Actividad por Profesional</h2>
            <p>Genera un reporte con la cantidad de pacientes únicos y sesiones por profesional en un período determinado. Incluye un gráfico comparativo.</p>
            <form action="reporte_actividad_profesional.php" method="get" target="_blank">
                <label for="start_date_actividad">Desde:</label>
                <input type="date" id="start_date_actividad" name="start_date" required>
                <label for="end_date_actividad">Hasta:</label>
                <input type="date" id="end_date_actividad" name="end_date" required>
                <button type="submit">Generar Reporte</button>
            </form>
        </div>

        <div class="report-section">
            <h2>Informe Financiero de la Clínica</h2>
            <p>Genera un estado de resultados detallado de la clínica, incluyendo ingresos, costos, gastos, IVA y el balance final para un período.</p>
            <form action="reporte_financiero_clinica.php" method="get" target="_blank">
                <label for="start_date_clinica">Desde:</label>
                <input type="date" id="start_date_clinica" name="start_date" required>
                <label for="end_date_clinica">Hasta:</label>
                <input type="date" id="end_date_clinica" name="end_date" required>
                <button type="submit">Generar Reporte</button>
            </form>
        </div>

        <!-- Aquí se añadirán las otras secciones de reportes -->

    </div>

    <script src="reportes.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>