<?php
// Función para leer la base de datos
function get_data() {
    $database_file = 'database.json';
    if (!file_exists($database_file)) return null;
    return json_decode(file_get_contents($database_file), true);
}

$profesional_id = $_GET['id'] ?? null;
if (!$profesional_id) die('Error: No se especificó un ID de profesional.');

$data = get_data();
$profesional = null;
$config = $data['configuracion'] ?? [];

foreach ($data['profesionales'] as $p) {
    if ($p['id'] === $profesional_id) {
        $profesional = $p;
        break;
    }
}

if (!$profesional) die('Error: Profesional no encontrado.');

$nombre_completo = htmlspecialchars($profesional['nombre'] . ' ' . $profesional['apellido']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ficha de Profesional - <?php echo $nombre_completo; ?></title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .page {
            width: 21cm;
            min-height: 29.7cm;
            padding: 2cm;
            margin: 1cm auto;
            border: 1px #D3D3D3 solid;
            border-radius: 5px;
            background: white;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }
        .toolbar {
            text-align: center;
            margin-bottom: 20px;
        }
        .toolbar button {
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
            background-color: #3498db;
            color: white;
            border: none;
            border-radius: 5px;
        }
        .report-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            border-bottom: 2px solid #3498db;
            padding-bottom: 15px;
            margin-bottom: 30px;
        }
        .report-header .clinic-info img {
            max-width: 100px;
            max-height: 100px;
        }
        .report-header .clinic-info h2 {
            margin: 0;
            color: #3498db;
        }
        .report-header .report-title {
            text-align: right;
        }
        .report-header .report-title h1 {
            margin: 0;
            font-size: 2em;
        }
        .content-grid {
            display: flex;
            gap: 30px;
        }
        .main-content {
            flex-grow: 1;
        }
        .sidebar {
            flex-shrink: 0;
            width: 150px;
            text-align: center;
        }
        .sidebar img {
            width: 100%;
            height: auto;
            border-radius: 8px;
            margin-bottom: 10px;
        }
        dl {
            margin-bottom: 20px;
        }
        dt {
            font-weight: bold;
            color: #555;
            margin-top: 10px;
        }
        dd {
            margin-left: 0;
            margin-bottom: 10px;
        }
        @media print {
            body, .page {
                margin: 0;
                box-shadow: none;
                border: none;
            }
            .toolbar {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="toolbar">
        <button onclick="window.print()">Imprimir o Guardar como PDF</button>
    </div>
    <div class="page">
        <div class="report-header">
            <div class="clinic-info">
                <?php if (!empty($config['clinica_logo'])): ?>
                    <img src="<?php echo htmlspecialchars($config['clinica_logo']); ?>" alt="Logo Clínica">
                <?php endif; ?>
                <h2><?php echo htmlspecialchars($config['clinica_nombre'] ?? 'Clínica'); ?></h2>
            </div>
            <div class="report-title">
                <h1>Ficha de Profesional</h1>
                <p>Fecha: <?php echo date('d/m/Y'); ?></p>
            </div>
        </div>
        <div class="content-grid">
            <div class="main-content">
                <dl>
                    <dt>Nombre Completo</dt><dd><?php echo $nombre_completo; ?></dd>
                    <dt>Especialidad</dt><dd><?php echo htmlspecialchars($profesional['especialidad']); ?></dd>
                    <dt>Matrícula Profesional</dt><dd><?php echo htmlspecialchars($profesional['matricula'] ?: 'No especificada'); ?></dd>
                    <dt>Email</dt><dd><?php echo htmlspecialchars($profesional['email']); ?></dd>
                    <dt>Teléfono</dt><dd><?php echo htmlspecialchars($profesional['telefono']); ?></dd>
                    <dt>Biografía</dt><dd><?php echo nl2br(htmlspecialchars($profesional['biografia'] ?: 'No especificada.')); ?></dd>
                </dl>
            </div>
            <?php if (!empty($profesional['foto'])): ?>
            <div class="sidebar">
                <img src="<?php echo htmlspecialchars($profesional['foto']); ?>" alt="Foto de <?php echo $nombre_completo; ?>">
            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>