<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>

    <div class="container">
        <div class="controls">
            <input type="text" id="search-input" placeholder="Buscar por nombre o apellido...">
            <button id="open-modal-btn">Nuevo Paciente</button>
        </div>

        <h2>Pacientes Registrados</h2>
        <table id="pacientes-table">
            <thead>
                <tr>
                <th data-sort="nombre">Nombre</th>
                <th data-sort="apellido">Apellido</th>
                <th>Teléfono</th>
                <th>Motivo de Consulta</th>
                <th>Profesional Asignado</th>
                <th>Estado</th>
                <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="pacientes-table-body">
                <!-- Filas insertadas por JavaScript -->
            </tbody>
        </table>

        <!-- The Modal -->
        <div id="paciente-modal" class="modal">
            <div class="modal-content">
            <span class="close-btn">&times;</span>
            <h2>Ficha del Paciente</h2>
            <form id="paciente-form">
                <input type="hidden" id="paciente-id" name="id">
                
                <div class="form-grid">
                    <input type="text" id="nombre" name="nombre" placeholder="Nombre" required>
                    <input type="text" id="apellido" name="apellido" placeholder="Apellido" required>
                    <input type="text" id="dni" name="dni" placeholder="Documento de Identidad">
                    <input type="date" id="fecha_nacimiento" name="fecha_nacimiento" placeholder="Fecha de Nacimiento">
                    <input type="tel" id="telefono" name="telefono">
                    <input type="email" id="email" name="email" placeholder="Email">
                    <select id="profesional_asignado_id" name="profesional_asignado_id">
                        <option value="">-- Asignar Profesional --</option>
                        <!-- Opciones cargadas por JS -->
                    </select>
                    <select id="estado" name="estado">
                        <option value="activo">Activo</option>
                        <option value="inactivo">Inactivo</option>
                        <option value="alta">De Alta</option>
                    </select>
                </div>

                <textarea id="motivo_consulta" name="motivo_consulta" placeholder="Motivo de la consulta..." rows="4"></textarea>
                <textarea id="antecedentes" name="antecedentes" placeholder="Antecedentes médicos y psicológicos relevantes..." rows="4"></textarea>
                <button type="submit">Guardar Paciente</button>
            </form>
            </div>
        </div>
    </div>

    <script src="pacientes.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>