<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>
<div class="container">
        <a href="pacientes.php" class="back-link">&larr; Volver a la lista de pacientes</a>
        <div class="patient-header-card">
            <div class="patient-info">
                <h1 id="patient-name">Cargando...</h1>
                <p><strong>DNI:</strong> <span id="patient-dni"></span></p>
                <p><strong>Teléfono:</strong> <span id="patient-phone"></span></p>
                <p><strong>Email:</strong> <span id="patient-email"></span></p>
            </div>
            <div class="patient-status">
                <p><strong>Profesional Asignado:</strong> <span id="patient-profesional"></span></p>
                <p><strong>Estado:</strong> <span id="patient-status-badge" class="status"></span></p>
            </div>
        </div>

        <div class="tabs-container">
            <div class="tab-nav">
                <button class="tab-link active" data-tab="tab-historial">Historial Clínico</button>
                <button class="tab-link" data-tab="tab-datos">Datos Personales</button>
                <button class="tab-link" data-tab="tab-citas">Citas</button>
            </div>

            <div id="tab-historial" class="tab-content active">
                <h2>Notas de Sesión</h2>
                <div id="new-note-container">
                    <button id="toggle-form-btn">Añadir Nueva Nota de Sesión <span class="arrow">&#9660;</span></button>
                    <div id="nota-form-wrapper" style="display: none;">
                        <form id="nota-form">
                            <input type="hidden" id="nota-id">
                            <input type="text" id="nota-titulo" placeholder="Título de la sesión" required>
                            <textarea id="nota-contenido" rows="6" placeholder="Escribe aquí la nota de evolución de la sesión..." required></textarea>
                            <div class="markdown-help">
                                <span id="markdown-help-toggle" class="help-toggle">? Ayuda de formato</span>
                                <div id="markdown-help-text" class="help-text" style="display: none;">Usa # para títulos, **negrita**, *cursiva* y - para listas.</div>
                            </div>
                            <label for="nota-adjunto">Adjuntar archivo (opcional):</label>
                            <input type="file" id="nota-adjunto">
                            <button type="submit">Guardar Nota</button>
                        </form>
                    </div>
                </div>
                <div class="notas-list-container">
                    <div id="notas-list"></div>
                </div>
            </div>

            <div id="tab-datos" class="tab-content">
                <h2>Datos Personales y de Contacto</h2>
                <div id="patient-details-content"></div>
            </div>

            <div id="tab-citas" class="tab-content">
                <h2>Citas del Paciente</h2>
                <div class="citas-list-container">
                    <h3>Próximas Citas</h3>
                    <div id="citas-programadas-list"></div>
                    <h3>Historial de Citas</h3>
                    <div id="citas-pasadas-list"></div>
                </div>
            </div>
        </div>
    </div>

    <script src="paciente_detalle.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>