<?php
session_start(); // Inicia la sesión para poder acceder a ella.

// Incluir la API para usar la función de logging
require_once 'api.php';

// Registrar la acción ANTES de destruir la sesión
log_activity('Cerró sesión en el sistema.');

// Elimina todas las variables de la sesión.
$_SESSION = array();

// Si se desea destruir la sesión completamente, borra también la cookie de sesión.
// Nota: ¡Esto destruirá la sesión, y no solo los datos de la sesión!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finalmente, destruye la sesión.
session_destroy();

// Redirige al usuario a la página de login.
header("Location: login.html");
exit;
?>