<?php
require(__DIR__ . '/fpdf/fpdf.php'); // Usamos una ruta absoluta para mayor seguridad

// Función para leer la base de datos (simplificada de api.php)
function get_data() {
    $database_file = 'database.json';
    if (!file_exists($database_file)) {
        return null;
    }
    return json_decode(file_get_contents($database_file), true);
}

$profesional_id = $_GET['id'] ?? null;

if (!$profesional_id) {
    die('Error: No se especificó un ID de profesional.');
}

$data = get_data();
$profesional = null;
$config = $data['configuracion'] ?? []; // Obtenemos la configuración de la clínica

foreach ($data['profesionales'] as $p) {
    if ($p['id'] === $profesional_id) {
        $profesional = $p;
        break;
    }
}

if (!$profesional) {
    die('Error: Profesional no encontrado.');
}

class PDF extends FPDF
{
    // Cabecera de página
    public $clinicLogo;

    function Header()
    {
        // Logo de la clínica
        if ($this->clinicLogo && file_exists($this->clinicLogo)) {
            $this->Image($this->clinicLogo, 10, 8, 30);
        }

        // Título
        $this->SetFont('Arial','B',15);
        $this->Cell(80);
        $this->Cell(30,10,'Ficha de Profesional',0,0,'C');
        
        // Salto de línea
        $this->Ln(20);
    }

    // Pie de página
    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
    }
}

// Creación del objeto de la clase heredada
$pdf = new PDF();
$pdf->clinicLogo = $config['clinica_logo'] ?? null; // Pasamos el logo a la clase PDF
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','',12);

// Foto del profesional
if (!empty($profesional['foto']) && @getimagesize($profesional['foto'])) {
    // Colocar la imagen a la derecha
    $pdf->Image($profesional['foto'], 150, 30, 40, 0, '', $profesional['foto']);
}

$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,utf8_decode('Nombre Completo:'));
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,utf8_decode($profesional['nombre'] . ' ' . $profesional['apellido']));
$pdf->Ln();

$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,utf8_decode('Especialidad:'));
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,utf8_decode($profesional['especialidad']));
$pdf->Ln();

$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,utf8_decode('Email:'));
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,utf8_decode($profesional['email']));
$pdf->Ln();

$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,utf8_decode('Teléfono:'));
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,utf8_decode($profesional['telefono']));
$pdf->Ln();

$pdf->SetFont('Arial','B',12);
$pdf->Cell(40,10,utf8_decode('Matrícula:'));
$pdf->SetFont('Arial','',12);
$pdf->Cell(0,10,utf8_decode($profesional['matricula'] ?: 'No especificada'));
$pdf->Ln(15);
$pdf->SetX(10); // Resetear la posición X
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,10,utf8_decode('Biografía:'),0,1);
$pdf->SetFont('Arial','',12);
$pdf->MultiCell(0,10,utf8_decode($profesional['biografia'] ?: 'No especificada.'));

$pdf->Output();
?>