<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>
    <div class="container">
        <h1>Gestión Financiera</h1>
        <!-- Incluimos la librería Chart.js -->
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

        <div class="summary-cards">
            <div class="summary-card ingresos">
                <h4>Total Ingresos</h4>
                <p id="summary-ingresos">0.00</p>
            </div>
            <div class="summary-card egresos">
                <h4>Total Egresos</h4>
                <p id="summary-egresos">0.00</p>
            </div>
            <div class="summary-card balance">
                <h4>Balance</h4>
                <p id="summary-balance">0.00</p>
            </div>
        </div>

        <!-- Contenedor para el nuevo gráfico -->
        <div class="chart-container">
            <canvas id="financial-overview-chart"></canvas>
        </div>

        <div class="controls-header">
            <div class="date-filters">
                <button class="filter-btn" data-period="today">Hoy</button>
                <button class="filter-btn" data-period="month">Este Mes</button>
                <button class="filter-btn active" data-period="all">Ver Todo</button>
                <button class="filter-btn" data-period="year">Este Año</button>
                <label for="start-date">Desde:</label>
                <input type="date" id="start-date">
                <label for="end-date">Hasta:</label>
                <input type="date" id="end-date">
            </div>
        </div>

        <!-- Sección de Ingresos -->
        <div class="financial-section">
            <h2>Ingresos</h2>
            <div class="controls-header">
                <input type="text" id="search-input-ingresos" placeholder="Buscar por paciente...">
                <button id="open-ingreso-modal-btn">Nuevo Ingreso</button>
            </div>
            <table id="ingresos-table">
                <thead>
                    <tr>
                        <th data-sort="referencia">N° / Referencia</th>
                        <th data-sort="fecha">Fecha</th>
                        <th data-sort="paciente">Paciente</th>
                        <th data-sort="monto">Monto</th>
                        <th data-sort="estado">Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="ingresos-table-body"></tbody>
            </table>
        </div>

        <!-- Sección de Egresos -->
        <div class="financial-section">
            <h2>Egresos</h2>
            <div class="controls-header">
                <input type="text" id="search-input-egresos" placeholder="Buscar por concepto o proveedor...">
                <button id="open-egreso-modal-btn">Nuevo Egreso</button>
            </div>
            <table id="egresos-table">
                <thead>
                    <tr>
                        <th data-sort="fecha">Fecha</th>
                        <th data-sort="concepto">Concepto</th>
                        <th data-sort="proveedor">Proveedor</th>
                        <th data-sort="monto">Monto</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="egresos-table-body"></tbody>
            </table>
        </div>

        <!-- Modal para Ingresos -->
        <div id="ingreso-modal" class="modal">
            <div class="modal-content">
                <span class="close-btn">&times;</span>
                <h2>Detalles del Ingreso</h2>
                <form id="ingreso-form">
                    <input type="hidden" id="ingreso-id" name="id">
                    <input type="hidden" id="cita_id" name="cita_id">
                    
                    <div class="form-grid-triple">
                        <input type="text" id="referencia" name="referencia" placeholder="N° de Factura o Referencia" required>
                        <input type="date" id="fecha" name="fecha" required>
                        <select id="paciente_id" name="paciente_id" required>
                            <option value="">-- Seleccionar Paciente --</option>
                        </select>
                        <input type="text" id="paciente_ruc" name="paciente_ruc" placeholder="RUC del Paciente">
                    </div>

                    <div class="items-container">
                        <h4>Ítems de la Factura</h4>
                        <div id="ingreso-items-list">
                            <!-- Los ítems se añadirán aquí dinámicamente -->
                        </div>
                        <button type="button" id="add-ingreso-item-btn">Añadir Ítem</button>
                    </div>

                    <div class="form-grid">
                        <select id="metodo_pago" name="metodo_pago">
                            <option value="">-- Método de Pago --</option>
                            <option value="Efectivo">Efectivo</option>
                            <option value="Tarjeta de Crédito">Tarjeta de Crédito</option>
                            <option value="Tarjeta de Débito">Tarjeta de Débito</option>
                            <option value="Transferencia Bancaria">Transferencia Bancaria</option>
                            <option value="QR">QR</option>
                        </select>
                        <select id="iva_tipo" name="iva_tipo" required>
                            <option value="exento">Exento de IVA</option>
                            <option value="5">IVA 5%</option>
                            <option value="10">IVA 10%</option>
                        </select>
                    </div>
                    <div class="form-grid">
                        <input type="number" id="monto_total" name="monto_total" placeholder="Monto Total" step="0.01" readonly required>
                        <select id="estado" name="estado" required>
                            <option value="Pendiente">Pendiente</option>
                            <option value="Pagada">Pagada</option>
                            <option value="Anulada">Anulada</option>
                        </select>
                    </div>
                    <button type="submit">Guardar Ingreso</button>
                </form>
            </div>
        </div>

        <!-- Modal para Egresos -->
        <div id="egreso-modal" class="modal">
            <div class="modal-content">
                <span class="close-btn">&times;</span>
                <h2>Detalles del Egreso</h2>
                <form id="egreso-form">
                    <input type="hidden" id="egreso-id" name="id">
                    <div class="form-grid-triple">
                        <input type="date" id="egreso-fecha" name="fecha" required>
                        <input type="text" id="egreso-proveedor" name="proveedor" placeholder="Proveedor">
                        <input type="text" id="egreso_ruc" name="egreso_ruc" placeholder="RUC del Proveedor">
                    </div>
                    <div class="items-container">
                        <h4>Ítems del Gasto</h4>
                        <div id="egreso-items-list">
                            <!-- Los ítems se añadirán aquí dinámicamente -->
                        </div>
                        <button type="button" id="add-egreso-item-btn">Añadir Ítem</button>
                    </div>
                    <input type="number" id="egreso-monto-total" name="monto_total" placeholder="Monto Total" step="0.01" readonly required>
                    <button type="submit">Guardar Egreso</button>
                </form>
            </div>
        </div>
    </div>

    <script src="financiero.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>