<?php
require_once '_header.php'; // Incluimos el header reutilizable
?>
    <div class="container">
        <div class="controls">
            <input type="text" id="search-input" placeholder="Buscar por paciente...">
            <div class="date-filters">
                <label for="start-date">Desde:</label>
                <input type="date" id="start-date">
                <label for="end-date">Hasta:</label>
                <input type="date" id="end-date">
                <button id="filter-btn">Filtrar</button>
            </div>
            <button id="open-modal-btn">Nueva Transacción</button>
        </div>

        <h2>Gestión Financiera</h2>
        <table id="transacciones-table">
            <thead>
                <tr>
                    <th data-sort="referencia">N° / Referencia</th>
                    <th data-sort="fecha">Fecha</th>
                    <th data-sort="paciente">Paciente</th>
                    <th data-sort="monto">Monto</th>
                    <th data-sort="estado">Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="transacciones-table-body">
                <!-- Filas insertadas por JavaScript -->
            </tbody>
        </table>

        <!-- The Modal -->
        <div id="transaccion-modal" class="modal">
            <div class="modal-content">
                <span class="close-btn">&times;</span>
                <h2>Detalles de la Transacción</h2>
                <form id="transaccion-form">
                    <input type="hidden" id="transaccion-id" name="id">
                    
                    <div class="form-grid">
                        <input type="text" id="referencia" name="referencia" placeholder="N° de Factura o Referencia" required>
                        <input type="date" id="fecha" name="fecha" required>
                        <select id="paciente_id" name="paciente_id" required>
                            <option value="">-- Seleccionar Paciente --</option>
                            <!-- Opciones cargadas por JS -->
                        </select>
                        <input type="number" id="monto" name="monto" placeholder="Monto" step="0.01" required>
                    </div>

                    <textarea id="concepto" name="concepto" placeholder="Concepto o descripción del servicio..." rows="3" required></textarea>

                    <div class="form-grid">
                        <select id="metodo_pago" name="metodo_pago">
                            <option value="">-- Método de Pago --</option>
                            <option value="Efectivo">Efectivo</option>
                            <option value="Tarjeta de Crédito">Tarjeta de Crédito</option>
                            <option value="Tarjeta de Débito">Tarjeta de Débito</option>
                            <option value="Transferencia Bancaria">Transferencia Bancaria</option>
                            <option value="QR">QR</option>
                        </select>
                        <select id="estado" name="estado" required>
                            <option value="Pendiente">Pendiente</option>
                            <option value="Pagada">Pagada</option>
                            <option value="Anulada">Anulada</option>
                        </select>
                    </div>
                    
                    <button type="submit">Guardar Transacción</button>
                </form>
            </div>
        </div>
    </div>

    <script src="financiero.js"></script>
<?php
require_once '_footer.php'; // Incluimos el footer reutilizable
?>