<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.html');
    exit;
}

$user_id_js = json_encode($_SESSION['user_id']);
$user_role = $_SESSION['user_role'] ?? 'profesional'; // Obtener el rol del usuario

// Cargar la configuración una sola vez para que esté disponible globalmente en JS
$config_data = [];
$db_file = 'database.json';
if (file_exists($db_file)) {
    $db_content = json_decode(file_get_contents($db_file), true);
    $config_data = $db_content['configuracion'] ?? [];
}
$config_json = json_encode($config_data);

// Determina el título de la página basado en el script actual
$page_title = 'Clinic App';
$current_page = basename($_SERVER['PHP_SELF']);
if ($current_page == 'index.php') $page_title = 'Dashboard - Clinic App';
if ($current_page == 'pacientes.php') $page_title = 'Pacientes - Clinic App';
if ($current_page == 'profesionales.php') $page_title = 'Profesionales - Clinic App';
if ($current_page == 'configuracion.php') $page_title = 'Configuración - Clinic App';
if ($current_page == 'citas.php') $page_title = 'Agenda de Citas - Clinic App';
if ($current_page == 'paciente_detalle.php') $page_title = 'Ficha del Paciente - Clinic App';
if ($current_page == 'financiero.php') $page_title = 'Financiero - Clinic App';
if ($current_page == 'reportes.php') $page_title = 'Reportes - Clinic App';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="style.css">
    <!-- Intl Tel Input for phone numbers -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css"/>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        // Inyectar datos de PHP a JS de forma segura
        const LOGGED_IN_USER_ID = <?php echo $user_id_js; ?>;
        const GLOBAL_CONFIG = <?php echo $config_json; ?>;
    </script>
    <script src="format.js" defer></script>
    <script src="global.js" defer></script>
    <?php if ($current_page == 'index.php') echo '<link rel="stylesheet" href="dashboard.css">'; ?>
    <?php if ($current_page == 'pacientes.php') echo '<link rel="stylesheet" href="pacientes.css">'; ?>
    <?php if ($current_page == 'configuracion.php') echo '<link rel="stylesheet" href="configuracion.css">'; ?>
    <?php if ($current_page == 'citas.php') echo '<link rel="stylesheet" href="citas.css">'; ?>
    <?php if ($current_page == 'financiero.php') echo '<link rel="stylesheet" href="financiero.css">'; ?>
    <?php if ($current_page == 'reportes.php') echo '<link rel="stylesheet" href="reportes.css">'; ?>
    <?php if ($current_page == 'paciente_detalle.php') echo '<link rel="stylesheet" href="paciente_detalle.css">'; ?>
</head>
<body>
    <header class="main-header">
        <div class="clinic-info">
            <a href="index.php" class="clinic-brand-link">
                <img id="clinic-logo" src="" alt="Logo de la Clínica">
                <span id="clinic-name"></span>
            </a>
        </div>
        <button id="mobile-menu-btn" class="mobile-menu-btn" aria-label="Abrir menú">
            <span></span>
            <span></span>
            <span></span>
        </button>
        <nav id="main-nav">
            <a href="index.php">Dashboard</a>
            <a href="pacientes.php">Pacientes</a>
            <a href="citas.php">Citas</a>
            <?php if ($user_role === 'admin'): ?>
                <a href="profesionales.php">Profesionales</a>
                <a href="financiero.php">Financiero</a>
                <a href="reportes.php">Reportes</a>
                <a href="configuracion.php">Configuración</a>
            <?php elseif ($user_role === 'secretario'): ?>
                <a href="financiero.php">Financiero</a>
            <?php endif; // El rol 'profesional' no ve enlaces adicionales ?>

            <div class="notification-area">
                <button id="notification-bell-btn" class="notification-bell-btn" aria-label="Ver notificaciones">
                    <span id="notification-badge" class="notification-badge" style="display: none;">0</span>
                </button>
                <div id="notification-panel" class="notification-panel" style="display: none;">
                    <div class="notification-panel-header">Notificaciones</div>
                    <div id="notification-list"></div>
                </div>
            </div>

            <span class="user-greeting">Hola, <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
            <a href="logout.php" class="logout-btn">Cerrar Sesión</a>
        </nav>
    </header>